/************************************************************************************************/
/* Stata User File for H113 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H113.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H113.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H113.DO                                               */
/* The program below will output the Stata dataset H113.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID07 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  str    HIEUIDX 31-37
  byte   FCSZ1231 38-39
  byte   FCRP1231 40-41
  str    RULETR31 42-43
  str    RULETR42 44-45
  str    RULETR53 46-47
  str    RULETR07 48-49
  byte   RUSIZE31 50-51
  byte   RUSIZE42 52-53
  byte   RUSIZE53 54-55
  byte   RUSIZE07 56-57
  byte   RUCLAS31 58-59
  byte   RUCLAS42 60-61
  byte   RUCLAS53 62-63
  byte   RUCLAS07 64-64
  byte   FAMSZE31 65-66
  byte   FAMSZE42 67-68
  byte   FAMSZE53 69-70
  byte   FAMSZE07 71-72
  byte   FMRS1231 73-74
  byte   FAMS1231 75-76
  byte   FAMSZEYR 77-78
  byte   FAMRFPYR 79-79
  byte   REGION31 80-81
  byte   REGION42 82-83
  byte   REGION53 84-85
  byte   REGION07 86-87
  byte   MSA31 88-89
  byte   MSA42 90-91
  byte   MSA53 92-93
  byte   MSA07 94-95
  int    REFPRS31 96-98
  int    REFPRS42 99-101
  int    REFPRS53 102-104
  int    REFPRS07 105-107
  byte   RESP31 108-108
  byte   RESP42 109-109
  byte   RESP53 110-110
  byte   RESP07 111-111
  byte   PROXY31 112-113
  byte   PROXY42 114-115
  byte   PROXY53 116-117
  byte   PROXY07 118-118
  byte   INTVLANG 119-120
  byte   BEGRFM31 121-122
  int    BEGRFY31 123-126
  byte   ENDRFM31 127-128
  int    ENDRFY31 129-132
  byte   BEGRFM42 133-134
  int    BEGRFY42 135-138
  byte   ENDRFM42 139-140
  int    ENDRFY42 141-144
  byte   BEGRFM53 145-146
  int    BEGRFY53 147-150
  byte   ENDRFM53 151-152
  int    ENDRFY53 153-156
  byte   ENDRFM07 157-158
  int    ENDRFY07 159-162
  byte   KEYNESS 163-163
  byte   INSCOP31 164-164
  byte   INSCOP42 165-165
  byte   INSCOP53 166-166
  byte   INSCOP07 167-167
  byte   INSC1231 168-168
  byte   INSCOPE 169-169
  byte   ELGRND31 170-170
  byte   ELGRND42 171-171
  byte   ELGRND53 172-172
  byte   ELGRND07 173-173
  byte   PSTATS31 174-175
  byte   PSTATS42 176-177
  byte   PSTATS53 178-179
  str    RURSLT31 180-181
  str    RURSLT42 182-183
  str    RURSLT53 184-185
  byte   AGE31X 186-187
  byte   AGE42X 188-189
  byte   AGE53X 190-191
  byte   AGE07X 192-193
  byte   DOBMM 194-195
  int    DOBYY 196-199
  byte   SEX 200-200
  byte   RACEX 201-201
  byte   RACEAX 202-202
  byte   RACEBX 203-203
  byte   RACEWX 204-204
  byte   RACETHNX 205-205
  byte   HISPANX 206-206
  byte   HISPCAT 207-208
  byte   MARRY31X 209-210
  byte   MARRY42X 211-212
  byte   MARRY53X 213-214
  byte   MARRY07X 215-216
  int    SPOUID31 217-219
  int    SPOUID42 220-222
  int    SPOUID53 223-225
  int    SPOUID07 226-228
  byte   SPOUIN31 229-230
  byte   SPOUIN42 231-232
  byte   SPOUIN53 233-234
  byte   SPOUIN07 235-236
  byte   EDUCYR 237-238
  byte   HIDEG 239-240
  byte   FTSTU31X 241-242
  byte   FTSTU42X 243-244
  byte   FTSTU53X 245-246
  byte   FTSTU07X 247-248
  byte   ACTDTY31 249-250
  byte   ACTDTY42 251-252
  byte   ACTDTY53 253-254
  byte   HONRDC31 255-256
  byte   HONRDC42 257-258
  byte   HONRDC53 259-260
  byte   RFREL31X 261-262
  byte   RFREL42X 263-264
  byte   RFREL53X 265-266
  byte   RFREL07X 267-268
  int    MOPID31X 269-271
  int    MOPID42X 272-274
  int    MOPID53X 275-277
  int    DAPID31X 278-280
  int    DAPID42X 281-283
  int    DAPID53X 284-286
  byte   SSIDIS07 287-288
  byte   AFDC07 289-290
  byte   FILEDR07 291-292
  byte   WILFIL07 293-294
  byte   FLSTAT07 295-296
  byte   FILER07 297-298
  byte   JTINRU07 299-300
  int    JNTPID07 301-303
  byte   CLMDEP07 304-305
  byte   DEPDNT07 306-307
  byte   DPINRU07 308-309
  byte   DPOTSD07 310-311
  byte   TAXFRM07 312-313
  byte   DEDUCT07 314-315
  double TOTDED07 316-324
  byte   CLMHIP07 325-326
  byte   EICRDT07 327-328
  byte   FOODST07 329-330
  byte   FOODMN07 331-332
  double FOODVL07 333-339
  long   TTLP07X 340-345
  long   FAMINC07 346-351
  byte   POVCAT07 352-352
  double POVLEV07 353-363
  long   WAGEP07X 364-369
  byte   WAGIMP07 370-370
  long   BUSNP07X 371-377
  byte   BUSIMP07 378-378
  long   UNEMP07X 379-383
  byte   UNEIMP07 384-384
  long   WCMPP07X 385-389
  byte   WCPIMP07 390-390
  long   INTRP07X 391-395
  byte   INTIMP07 396-396
  long   DIVDP07X 397-401
  byte   DIVIMP07 402-402
  long   SALEP07X 403-408
  byte   SALIMP07 409-409
  long   PENSP07X 410-414
  byte   PENIMP07 415-415
  long   SSECP07X 416-420
  byte   SSCIMP07 421-421
  long   TRSTP07X 422-427
  byte   TRTIMP07 428-428
  long   VETSP07X 429-433
  byte   VETIMP07 434-434
  long   IRASP07X 435-439
  byte   IRAIMP07 440-440
  long   REFDP07X 441-445
  byte   REFIMP07 446-446
  long   ALIMP07X 447-451
  byte   ALIIMP07 452-452
  long   CHLDP07X 453-458
  byte   CHLIMP07 459-459
  long   CASHP07X 460-465
  byte   CSHIMP07 466-466
  long   SSIP07X 467-471
  byte   SSIIMP07 472-472
  long   PUBP07X 473-477
  byte   PUBIMP07 478-478
  long   OTHRP07X 479-483
  byte   OTHIMP07 484-484
  byte   RTHLTH31 485-486
  byte   RTHLTH42 487-488
  byte   RTHLTH53 489-490
  byte   MNHLTH31 491-492
  byte   MNHLTH42 493-494
  byte   MNHLTH53 495-496
  byte   HIBPDX 497-498
  byte   BPMLDX 499-500
  byte   CHDDX 501-502
  byte   ANGIDX 503-504
  byte   MIDX 505-506
  byte   OHRTDX 507-508
  byte   STRKDX 509-510
  byte   EMPHDX 511-512
  byte   CHOLDX 513-514
  byte   CHLAGE 515-516
  byte   DIABDX 517-518
  byte   JTPAIN31 519-520
  byte   JTPAIN53 521-522
  byte   ARTHDX 523-524
  byte   ASTHDX 525-526
  byte   ASSTIL31 527-528
  byte   ASSTIL53 529-530
  byte   ASATAK31 531-532
  byte   ASATAK53 533-534
  byte   ASACUT53 535-536
  byte   ASMRCN53 537-538
  byte   ASPREV53 539-540
  byte   ASDALY53 541-542
  byte   ASPKFL53 543-544
  byte   ASEVFL53 545-546
  byte   ASWNFL53 547-548
  byte   IADLHP31 549-550
  byte   IADLHP42 551-552
  byte   IADLHP53 553-554
  byte   IADL3M31 555-556
  byte   IADL3M42 557-558
  byte   IADL3M53 559-560
  byte   ADLHLP31 561-562
  byte   ADLHLP42 563-564
  byte   ADLHLP53 565-566
  byte   ADL3MO31 567-568
  byte   ADL3MO42 569-570
  byte   ADL3MO53 571-572
  byte   AIDHLP31 573-574
  byte   AIDHLP53 575-576
  byte   WLKLIM31 577-578
  byte   WLKLIM53 579-580
  byte   LFTDIF31 581-582
  byte   LFTDIF53 583-584
  byte   STPDIF31 585-586
  byte   STPDIF53 587-588
  byte   WLKDIF31 589-590
  byte   WLKDIF53 591-592
  byte   MILDIF31 593-594
  byte   MILDIF53 595-596
  byte   STNDIF31 597-598
  byte   STNDIF53 599-600
  byte   BENDIF31 601-602
  byte   BENDIF53 603-604
  byte   RCHDIF31 605-606
  byte   RCHDIF53 607-608
  byte   FNGRDF31 609-610
  byte   FNGRDF53 611-612
  byte   WLK3MO31 613-614
  byte   WLK3MO53 615-616
  byte   ACTLIM31 617-618
  byte   ACTLIM53 619-620
  byte   WRKLIM31 621-622
  byte   WRKLIM53 623-624
  byte   HSELIM31 625-626
  byte   HSELIM53 627-628
  byte   SCHLIM31 629-630
  byte   SCHLIM53 631-632
  byte   UNABLE31 633-634
  byte   UNABLE53 635-636
  byte   SOCLIM31 637-638
  byte   SOCLIM53 639-640
  byte   COGLIM31 641-642
  byte   COGLIM53 643-644
  byte   WRGLAS42 645-646
  byte   SEEDIF42 647-648
  byte   BLIND42 649-650
  byte   READNW42 651-652
  byte   RECPEP42 653-654
  byte   VISION42 655-656
  byte   HEARAD42 657-658
  byte   HEARDI42 659-660
  byte   DEAF42 661-662
  byte   HEARMO42 663-664
  byte   HEARSM42 665-666
  byte   HEARNG42 667-668
  byte   ANYLIM07 669-670
  byte   LSHLTH42 671-672
  byte   NEVILL42 673-674
  byte   SICEAS42 675-676
  byte   HLTHLF42 677-678
  byte   WRHLTH42 679-680
  byte   CHPMED42 681-682
  byte   CHPMHB42 683-684
  byte   CHPMCN42 685-686
  byte   CHSERV42 687-688
  byte   CHSRHB42 689-690
  byte   CHSRCN42 691-692
  byte   CHLIMI42 693-694
  byte   CHLIHB42 695-696
  byte   CHLICO42 697-698
  byte   CHTHER42 699-700
  byte   CHTHHB42 701-702
  byte   CHTHCO42 703-704
  byte   CHCOUN42 705-706
  byte   CHEMPB42 707-708
  byte   CSHCN42 709-710
  byte   MOMPRO42 711-712
  byte   DADPRO42 713-714
  byte   UNHAP42 715-716
  byte   SCHLBH42 717-718
  byte   HAVFUN42 719-720
  byte   ADUPRO42 721-722
  byte   NERVAF42 723-724
  byte   SIBPRO42 725-726
  byte   KIDPRO42 727-728
  byte   SPRPRO42 729-730
  byte   SCHPRO42 731-732
  byte   HOMEBH42 733-734
  byte   TRBLE42 735-736
  byte   CHILCR42 737-738
  byte   CHILWW42 739-740
  byte   CHRTCR42 741-742
  byte   CHRTWW42 743-744
  byte   CHAPPT42 745-746
  byte   CHNDCR42 747-748
  byte   CHNECP42 749-750
  byte   CHLIST42 751-752
  byte   CHEXPL42 753-754
  byte   CHRESP42 755-756
  byte   CHPRTM42 757-758
  byte   CHHECR42 759-760
  byte   CHSPEC42 761-762
  byte   CHPRRE42 763-764
  byte   MESHGT42 765-766
  byte   WHNHGT42 767-768
  byte   MESWGT42 769-770
  byte   WHNWGT42 771-772
  double CHBMIX42 773-776
  byte   MESVIS42 777-778
  byte   MESBPR42 779-780
  byte   WHNBPR42 781-782
  byte   DENTAL42 783-784
  byte   WHNDEN42 785-786
  byte   EATHLT42 787-788
  byte   WHNEAT42 789-790
  byte   PHYSCL42 791-792
  byte   WHNPHY42 793-794
  byte   SAFEST42 795-796
  byte   WHNSAF42 797-798
  byte   BOOST42 799-800
  byte   WHNBST42 801-802
  byte   LAPBLT42 803-804
  byte   WHNLAP42 805-806
  byte   HELMET42 807-808
  byte   WHNHEL42 809-810
  byte   NOSMOK42 811-812
  byte   WHNSMK42 813-814
  byte   TIMALN42 815-816
  byte   DENTCK53 817-818
  byte   BPCHEK53 819-820
  byte   BPMONT53 821-822
  byte   CHOLCK53 823-824
  byte   CHECK53 825-826
  byte   NOFAT53 827-828
  byte   EXRCIS53 829-830
  byte   FLUSHT53 831-832
  byte   ASPRIN53 833-834
  byte   NOASPR53 835-836
  byte   STOMCH53 837-838
  byte   LSTETH53 839-840
  byte   PSA53 841-842
  byte   HYSTER53 843-844
  byte   PAPSMR53 845-846
  byte   BRSTEX53 847-848
  byte   MAMOGR53 849-850
  byte   STOOL53 851-852
  byte   WHENST53 853-854
  byte   BOWEL53 855-856
  byte   WHNBWL53 857-858
  byte   PHYACT53 859-860
  double BMINDX53 861-865
  byte   SEATBE53 866-867
  byte   SAQELIG 868-868
  int    ADPRX42 869-871
  byte   ADILCR42 872-873
  byte   ADILWW42 874-875
  byte   ADRTCR42 876-877
  byte   ADRTWW42 878-879
  byte   ADAPPT42 880-881
  byte   ADNDCR42 882-883
  byte   ADNECP42 884-885
  byte   ADLIST42 886-887
  byte   ADEXPL42 888-889
  byte   ADRESP42 890-891
  byte   ADPRTM42 892-893
  byte   ADHECR42 894-895
  byte   ADSMOK42 896-897
  byte   ADNSMK42 898-899
  byte   ADDRBP42 900-901
  byte   ADSPEC42 902-903
  byte   ADPRRE42 904-905
  byte   ADGENH42 906-907
  byte   ADDAYA42 908-909
  byte   ADCLIM42 910-911
  byte   ADPALS42 912-913
  byte   ADPWLM42 914-915
  byte   ADMALS42 916-917
  byte   ADMWLM42 918-919
  byte   ADPAIN42 920-921
  byte   ADCAPE42 922-923
  byte   ADNRGY42 924-925
  byte   ADDOWN42 926-927
  byte   ADSOCA42 928-929
  double PCS42 930-934
  double MCS42 935-939
  byte   SFFLAG42 940-941
  byte   ADNERV42 942-943
  byte   ADHOPE42 944-945
  byte   ADREST42 946-947
  byte   ADSAD42 948-949
  byte   ADEFRT42 950-951
  byte   ADWRTH42 952-953
  byte   K6SUM42 954-955
  byte   ADINTR42 956-957
  byte   ADDPRS42 958-959
  double PHQ242 960-964
  byte   ADINSA42 965-966
  byte   ADINSB42 967-968
  byte   ADRISK42 969-970
  byte   ADOVER42 971-972
  byte   ADCMPM42 973-974
  byte   ADCMPD42 975-976
  int    ADCMPY42 977-980
  byte   ADLANG42 981-982
  byte   DSDIA53 983-984
  byte   DSA1C53 985-986
  byte   DSCKFT53 987-988
  byte   DSEY0853 989-990
  byte   DSEY0753 991-992
  byte   DSEY0653 993-994
  byte   DSEB0653 995-996
  byte   DSEYNV53 997-998
  byte   DSKIDN53 999-1000
  byte   DSEYPR53 1001-1002
  byte   DSDIET53 1003-1004
  byte   DSMED53 1005-1006
  byte   DSINSU53 1007-1008
  byte   PHONE53 1009-1010
  byte   NURSE53 1011-1012
  byte   VISIT53 1013-1014
  byte   REFER53 1015-1016
  byte   CHLCHK53 1017-1018
  byte   FLSHOT53 1019-1020
  byte   DSPRX53 1021-1022
  int    DDNWRK31 1023-1025
  int    DDNWRK42 1026-1028
  int    DDNWRK53 1029-1031
  int    WKINBD31 1032-1034
  int    WKINBD42 1035-1037
  int    WKINBD53 1038-1040
  byte   DDNSCL31 1041-1042
  int    DDNSCL42 1043-1045
  byte   DDNSCL53 1046-1047
  byte   SCLNBD31 1048-1049
  byte   SCLNBD42 1050-1051
  byte   SCLNBD53 1052-1053
  int    DDBDYS31 1054-1056
  int    DDBDYS42 1057-1059
  int    DDBDYS53 1060-1062
  byte   OTHDYS31 1063-1064
  byte   OTHDYS42 1065-1066
  byte   OTHDYS53 1067-1068
  int    OTHNDD31 1069-1071
  byte   OTHNDD42 1072-1073
  byte   OTHNDD53 1074-1075
  byte   ACCELI42 1076-1077
  byte   LANGHM42 1078-1079
  byte   ENGHME42 1080-1081
  byte   ENGSPK42 1082-1083
  byte   USBORN42 1084-1085
  byte   USLIVE42 1086-1087
  byte   HAVEUS42 1088-1089
  byte   YNOUSC42 1090-1091
  byte   NOREAS42 1092-1093
  byte   SELDSI42 1094-1095
  byte   NEWARE42 1096-1097
  byte   DKWHRU42 1098-1099
  byte   USCNOT42 1100-1101
  byte   PERSLA42 1102-1103
  byte   DIFFPL42 1104-1105
  byte   INSRPL42 1106-1107
  byte   MYSELF42 1108-1109
  byte   CARECO42 1110-1111
  byte   OTHINS42 1112-1113
  byte   JOBRSN42 1114-1115
  byte   NEWDOC42 1116-1117
  byte   DOCELS42 1118-1119
  byte   NOLIKE42 1120-1121
  byte   HEALTH42 1122-1123
  byte   KNOWDR42 1124-1125
  byte   ONJOB42 1126-1127
  byte   NOGODR42 1128-1129
  byte   TRANS42 1130-1131
  byte   CLINIC42 1132-1133
  byte   OTHREA42 1134-1135
  byte   PROVTY42 1136-1137
  byte   FACLPR42 1138-1139
  byte   PLCTYP42 1140-1141
  byte   GOTOUS42 1142-1143
  byte   TMTKUS42 1144-1145
  byte   DFTOUS42 1146-1147
  byte   TYPEPE42 1148-1149
  byte   LOCATN42 1150-1151
  byte   HSPLAP42 1152-1153
  byte   WHITPR42 1154-1155
  byte   BLCKPR42 1156-1157
  byte   ASIANP42 1158-1159
  byte   NATAMP42 1160-1161
  byte   PACISP42 1162-1163
  byte   OTHRCP42 1164-1165
  byte   GENDRP42 1166-1167
  byte   MINORP42 1168-1169
  byte   PREVEN42 1170-1171
  byte   REFFRL42 1172-1173
  byte   ONGONG42 1174-1175
  byte   PHNREG42 1176-1177
  byte   OFFHOU42 1178-1179
  byte   AFTHOU42 1180-1181
  byte   TREATM42 1182-1183
  byte   RESPCT42 1184-1185
  byte   DECIDE42 1186-1187
  byte   EXPLOP42 1188-1189
  byte   LANGPR42 1190-1191
  byte   MDUNAB42 1192-1193
  byte   MDUNRS42 1194-1195
  byte   MDUNPR42 1196-1197
  byte   MDDLAY42 1198-1199
  byte   MDDLRS42 1200-1201
  byte   MDDLPR42 1202-1203
  byte   DNUNAB42 1204-1205
  byte   DNUNRS42 1206-1207
  byte   DNUNPR42 1208-1209
  byte   DNDLAY42 1210-1211
  byte   DNDLRS42 1212-1213
  byte   DNDLPR42 1214-1215
  byte   PMUNAB42 1216-1217
  byte   PMUNRS42 1218-1219
  byte   PMUNPR42 1220-1221
  byte   PMDLAY42 1222-1223
  byte   PMDLRS42 1224-1225
  byte   PMDLPR42 1226-1227
  byte   EMPST31 1228-1229
  byte   EMPST42 1230-1231
  byte   EMPST53 1232-1233
  byte   RNDFLG31 1234-1235
  byte   MORJOB31 1236-1237
  byte   MORJOB42 1238-1239
  byte   MORJOB53 1240-1241
  byte   EVRWRK 1242-1243
  double HRWG31X 1244-1249
  double HRWG42X 1250-1255
  double HRWG53X 1256-1261
  byte   HRWGIM31 1262-1262
  byte   HRWGIM42 1263-1263
  byte   HRWGIM53 1264-1264
  byte   HRHOW31 1265-1266
  byte   HRHOW42 1267-1268
  byte   HRHOW53 1269-1270
  byte   DIFFWG31 1271-1272
  byte   DIFFWG42 1273-1274
  byte   DIFFWG53 1275-1276
  double NHRWG31 1277-1282
  double NHRWG42 1283-1288
  double NHRWG53 1289-1294
  int    HOUR31 1295-1297
  int    HOUR42 1298-1300
  byte   HOUR53 1301-1302
  byte   TEMPJB31 1303-1304
  byte   TEMPJB42 1305-1306
  byte   TEMPJB53 1307-1308
  byte   SSNLJB31 1309-1310
  byte   SSNLJB42 1311-1312
  byte   SSNLJB53 1313-1314
  byte   SELFCM31 1315-1316
  byte   SELFCM42 1317-1318
  byte   SELFCM53 1319-1320
  byte   DISVW31X 1321-1322
  byte   DISVW42X 1323-1324
  byte   DISVW53X 1325-1326
  byte   CHOIC31 1327-1328
  byte   CHOIC42 1329-1330
  byte   CHOIC53 1331-1332
  byte   INDCAT31 1333-1334
  byte   INDCAT42 1335-1336
  byte   INDCAT53 1337-1338
  int    NUMEMP31 1339-1341
  int    NUMEMP42 1342-1344
  int    NUMEMP53 1345-1347
  byte   MORE31 1348-1349
  byte   MORE42 1350-1351
  byte   MORE53 1352-1353
  byte   UNION31 1354-1355
  byte   UNION42 1356-1357
  byte   UNION53 1358-1359
  byte   NWK31 1360-1361
  byte   NWK42 1362-1363
  byte   NWK53 1364-1365
  byte   CHGJ3142 1366-1367
  byte   CHGJ4253 1368-1369
  byte   YCHJ3142 1370-1371
  byte   YCHJ4253 1372-1373
  byte   STJBMM31 1374-1375
  byte   STJBDD31 1376-1377
  int    STJBYY31 1378-1381
  byte   STJBMM42 1382-1383
  byte   STJBDD42 1384-1385
  int    STJBYY42 1386-1389
  byte   STJBMM53 1390-1391
  byte   STJBDD53 1392-1393
  int    STJBYY53 1394-1397
  byte   EVRETIRE 1398-1399
  byte   OCCCAT31 1400-1401
  byte   OCCCAT42 1402-1403
  byte   OCCCAT53 1404-1405
  byte   PAYVAC31 1406-1407
  byte   PAYVAC42 1408-1409
  byte   PAYVAC53 1410-1411
  byte   SICPAY31 1412-1413
  byte   SICPAY42 1414-1415
  byte   SICPAY53 1416-1417
  byte   PAYDR31 1418-1419
  byte   PAYDR42 1420-1421
  byte   PAYDR53 1422-1423
  byte   RETPLN31 1424-1425
  byte   RETPLN42 1426-1427
  byte   RETPLN53 1428-1429
  byte   BSNTY31 1430-1431
  byte   BSNTY42 1432-1433
  byte   BSNTY53 1434-1435
  byte   JOBORG31 1436-1437
  byte   JOBORG42 1438-1439
  byte   JOBORG53 1440-1441
  byte   HELD31X 1442-1443
  byte   HELD42X 1444-1445
  byte   HELD53X 1446-1447
  byte   OFFER31X 1448-1449
  byte   OFFER42X 1450-1451
  byte   OFFER53X 1452-1453
  byte   OFREMP31 1454-1455
  byte   OFREMP42 1456-1457
  byte   OFREMP53 1458-1459
  byte   YNOINS31 1460-1461
  byte   YNOINS42 1462-1463
  byte   YNOINS53 1464-1465
  byte   TRIJA07X 1466-1467
  byte   TRIFE07X 1468-1469
  byte   TRIMA07X 1470-1471
  byte   TRIAP07X 1472-1473
  byte   TRIMY07X 1474-1475
  byte   TRIJU07X 1476-1477
  byte   TRIJL07X 1478-1479
  byte   TRIAU07X 1480-1481
  byte   TRISE07X 1482-1483
  byte   TRIOC07X 1484-1485
  byte   TRINO07X 1486-1487
  byte   TRIDE07X 1488-1489
  byte   MCRJA07 1490-1491
  byte   MCRFE07 1492-1493
  byte   MCRMA07 1494-1495
  byte   MCRAP07 1496-1497
  byte   MCRMY07 1498-1499
  byte   MCRJU07 1500-1501
  byte   MCRJL07 1502-1503
  byte   MCRAU07 1504-1505
  byte   MCRSE07 1506-1507
  byte   MCROC07 1508-1509
  byte   MCRNO07 1510-1511
  byte   MCRDE07 1512-1513
  byte   MCRJA07X 1514-1515
  byte   MCRFE07X 1516-1517
  byte   MCRMA07X 1518-1519
  byte   MCRAP07X 1520-1521
  byte   MCRMY07X 1522-1523
  byte   MCRJU07X 1524-1525
  byte   MCRJL07X 1526-1527
  byte   MCRAU07X 1528-1529
  byte   MCRSE07X 1530-1531
  byte   MCROC07X 1532-1533
  byte   MCRNO07X 1534-1535
  byte   MCRDE07X 1536-1537
  byte   MCDJA07 1538-1539
  byte   MCDFE07 1540-1541
  byte   MCDMA07 1542-1543
  byte   MCDAP07 1544-1545
  byte   MCDMY07 1546-1547
  byte   MCDJU07 1548-1549
  byte   MCDJL07 1550-1551
  byte   MCDAU07 1552-1553
  byte   MCDSE07 1554-1555
  byte   MCDOC07 1556-1557
  byte   MCDNO07 1558-1559
  byte   MCDDE07 1560-1561
  byte   MCDJA07X 1562-1563
  byte   MCDFE07X 1564-1565
  byte   MCDMA07X 1566-1567
  byte   MCDAP07X 1568-1569
  byte   MCDMY07X 1570-1571
  byte   MCDJU07X 1572-1573
  byte   MCDJL07X 1574-1575
  byte   MCDAU07X 1576-1577
  byte   MCDSE07X 1578-1579
  byte   MCDOC07X 1580-1581
  byte   MCDNO07X 1582-1583
  byte   MCDDE07X 1584-1585
  byte   OPAJA07 1586-1587
  byte   OPAFE07 1588-1589
  byte   OPAMA07 1590-1591
  byte   OPAAP07 1592-1593
  byte   OPAMY07 1594-1595
  byte   OPAJU07 1596-1597
  byte   OPAJL07 1598-1599
  byte   OPAAU07 1600-1601
  byte   OPASE07 1602-1603
  byte   OPAOC07 1604-1605
  byte   OPANO07 1606-1607
  byte   OPADE07 1608-1609
  byte   OPBJA07 1610-1611
  byte   OPBFE07 1612-1613
  byte   OPBMA07 1614-1615
  byte   OPBAP07 1616-1617
  byte   OPBMY07 1618-1619
  byte   OPBJU07 1620-1621
  byte   OPBJL07 1622-1623
  byte   OPBAU07 1624-1625
  byte   OPBSE07 1626-1627
  byte   OPBOC07 1628-1629
  byte   OPBNO07 1630-1631
  byte   OPBDE07 1632-1633
  byte   STAJA07 1634-1635
  byte   STAFE07 1636-1637
  byte   STAMA07 1638-1639
  byte   STAAP07 1640-1641
  byte   STAMY07 1642-1643
  byte   STAJU07 1644-1645
  byte   STAJL07 1646-1647
  byte   STAAU07 1648-1649
  byte   STASE07 1650-1651
  byte   STAOC07 1652-1653
  byte   STANO07 1654-1655
  byte   STADE07 1656-1657
  byte   PUBJA07X 1658-1659
  byte   PUBFE07X 1660-1661
  byte   PUBMA07X 1662-1663
  byte   PUBAP07X 1664-1665
  byte   PUBMY07X 1666-1667
  byte   PUBJU07X 1668-1669
  byte   PUBJL07X 1670-1671
  byte   PUBAU07X 1672-1673
  byte   PUBSE07X 1674-1675
  byte   PUBOC07X 1676-1677
  byte   PUBNO07X 1678-1679
  byte   PUBDE07X 1680-1681
  byte   PEGJA07 1682-1683
  byte   PEGFE07 1684-1685
  byte   PEGMA07 1686-1687
  byte   PEGAP07 1688-1689
  byte   PEGMY07 1690-1691
  byte   PEGJU07 1692-1693
  byte   PEGJL07 1694-1695
  byte   PEGAU07 1696-1697
  byte   PEGSE07 1698-1699
  byte   PEGOC07 1700-1701
  byte   PEGNO07 1702-1703
  byte   PEGDE07 1704-1705
  byte   PDKJA07 1706-1707
  byte   PDKFE07 1708-1709
  byte   PDKMA07 1710-1711
  byte   PDKAP07 1712-1713
  byte   PDKMY07 1714-1715
  byte   PDKJU07 1716-1717
  byte   PDKJL07 1718-1719
  byte   PDKAU07 1720-1721
  byte   PDKSE07 1722-1723
  byte   PDKOC07 1724-1725
  byte   PDKNO07 1726-1727
  byte   PDKDE07 1728-1729
  byte   PNGJA07 1730-1731
  byte   PNGFE07 1732-1733
  byte   PNGMA07 1734-1735
  byte   PNGAP07 1736-1737
  byte   PNGMY07 1738-1739
  byte   PNGJU07 1740-1741
  byte   PNGJL07 1742-1743
  byte   PNGAU07 1744-1745
  byte   PNGSE07 1746-1747
  byte   PNGOC07 1748-1749
  byte   PNGNO07 1750-1751
  byte   PNGDE07 1752-1753
  byte   POGJA07 1754-1755
  byte   POGFE07 1756-1757
  byte   POGMA07 1758-1759
  byte   POGAP07 1760-1761
  byte   POGMY07 1762-1763
  byte   POGJU07 1764-1765
  byte   POGJL07 1766-1767
  byte   POGAU07 1768-1769
  byte   POGSE07 1770-1771
  byte   POGOC07 1772-1773
  byte   POGNO07 1774-1775
  byte   POGDE07 1776-1777
  byte   PRSJA07 1778-1779
  byte   PRSFE07 1780-1781
  byte   PRSMA07 1782-1783
  byte   PRSAP07 1784-1785
  byte   PRSMY07 1786-1787
  byte   PRSJU07 1788-1789
  byte   PRSJL07 1790-1791
  byte   PRSAU07 1792-1793
  byte   PRSSE07 1794-1795
  byte   PRSOC07 1796-1797
  byte   PRSNO07 1798-1799
  byte   PRSDE07 1800-1801
  byte   POUJA07 1802-1803
  byte   POUFE07 1804-1805
  byte   POUMA07 1806-1807
  byte   POUAP07 1808-1809
  byte   POUMY07 1810-1811
  byte   POUJU07 1812-1813
  byte   POUJL07 1814-1815
  byte   POUAU07 1816-1817
  byte   POUSE07 1818-1819
  byte   POUOC07 1820-1821
  byte   POUNO07 1822-1823
  byte   POUDE07 1824-1825
  byte   PRIJA07 1826-1827
  byte   PRIFE07 1828-1829
  byte   PRIMA07 1830-1831
  byte   PRIAP07 1832-1833
  byte   PRIMY07 1834-1835
  byte   PRIJU07 1836-1837
  byte   PRIJL07 1838-1839
  byte   PRIAU07 1840-1841
  byte   PRISE07 1842-1843
  byte   PRIOC07 1844-1845
  byte   PRINO07 1846-1847
  byte   PRIDE07 1848-1849
  byte   HPEJA07 1850-1851
  byte   HPEFE07 1852-1853
  byte   HPEMA07 1854-1855
  byte   HPEAP07 1856-1857
  byte   HPEMY07 1858-1859
  byte   HPEJU07 1860-1861
  byte   HPEJL07 1862-1863
  byte   HPEAU07 1864-1865
  byte   HPESE07 1866-1867
  byte   HPEOC07 1868-1869
  byte   HPENO07 1870-1871
  byte   HPEDE07 1872-1873
  byte   HPDJA07 1874-1875
  byte   HPDFE07 1876-1877
  byte   HPDMA07 1878-1879
  byte   HPDAP07 1880-1881
  byte   HPDMY07 1882-1883
  byte   HPDJU07 1884-1885
  byte   HPDJL07 1886-1887
  byte   HPDAU07 1888-1889
  byte   HPDSE07 1890-1891
  byte   HPDOC07 1892-1893
  byte   HPDNO07 1894-1895
  byte   HPDDE07 1896-1897
  byte   HPNJA07 1898-1899
  byte   HPNFE07 1900-1901
  byte   HPNMA07 1902-1903
  byte   HPNAP07 1904-1905
  byte   HPNMY07 1906-1907
  byte   HPNJU07 1908-1909
  byte   HPNJL07 1910-1911
  byte   HPNAU07 1912-1913
  byte   HPNSE07 1914-1915
  byte   HPNOC07 1916-1917
  byte   HPNNO07 1918-1919
  byte   HPNDE07 1920-1921
  byte   HPOJA07 1922-1923
  byte   HPOFE07 1924-1925
  byte   HPOMA07 1926-1927
  byte   HPOAP07 1928-1929
  byte   HPOMY07 1930-1931
  byte   HPOJU07 1932-1933
  byte   HPOJL07 1934-1935
  byte   HPOAU07 1936-1937
  byte   HPOSE07 1938-1939
  byte   HPOOC07 1940-1941
  byte   HPONO07 1942-1943
  byte   HPODE07 1944-1945
  byte   HPSJA07 1946-1947
  byte   HPSFE07 1948-1949
  byte   HPSMA07 1950-1951
  byte   HPSAP07 1952-1953
  byte   HPSMY07 1954-1955
  byte   HPSJU07 1956-1957
  byte   HPSJL07 1958-1959
  byte   HPSAU07 1960-1961
  byte   HPSSE07 1962-1963
  byte   HPSOC07 1964-1965
  byte   HPSNO07 1966-1967
  byte   HPSDE07 1968-1969
  byte   HPRJA07 1970-1971
  byte   HPRFE07 1972-1973
  byte   HPRMA07 1974-1975
  byte   HPRAP07 1976-1977
  byte   HPRMY07 1978-1979
  byte   HPRJU07 1980-1981
  byte   HPRJL07 1982-1983
  byte   HPRAU07 1984-1985
  byte   HPRSE07 1986-1987
  byte   HPROC07 1988-1989
  byte   HPRNO07 1990-1991
  byte   HPRDE07 1992-1993
  byte   INSJA07X 1994-1995
  byte   INSFE07X 1996-1997
  byte   INSMA07X 1998-1999
  byte   INSAP07X 2000-2001
  byte   INSMY07X 2002-2003
  byte   INSJU07X 2004-2005
  byte   INSJL07X 2006-2007
  byte   INSAU07X 2008-2009
  byte   INSSE07X 2010-2011
  byte   INSOC07X 2012-2013
  byte   INSNO07X 2014-2015
  byte   INSDE07X 2016-2017
  byte   PRVEV07 2018-2018
  byte   TRIEV07 2019-2019
  byte   MCREV07 2020-2020
  byte   MCDEV07 2021-2021
  byte   OPAEV07 2022-2022
  byte   OPBEV07 2023-2023
  byte   UNINS07 2024-2024
  byte   INSCOV07 2025-2025
  byte   TRIST31X 2026-2027
  byte   TRIST42X 2028-2029
  byte   TRIST07X 2030-2031
  byte   TRIPR31X 2032-2033
  byte   TRIPR42X 2034-2035
  byte   TRIPR07X 2036-2037
  byte   TRIEX31X 2038-2039
  byte   TRIEX42X 2040-2041
  byte   TRIEX07X 2042-2043
  byte   TRILI31X 2044-2045
  byte   TRILI42X 2046-2047
  byte   TRILI07X 2048-2049
  byte   TRICH31X 2050-2051
  byte   TRICH42X 2052-2053
  byte   TRICH07X 2054-2055
  byte   MCRPD31 2056-2057
  byte   MCRPD42 2058-2059
  byte   MCRPD07 2060-2061
  byte   MCRPD31X 2062-2063
  byte   MCRPD42X 2064-2065
  byte   MCRPD07X 2066-2067
  byte   MCRPHO31 2068-2069
  byte   MCRPHO42 2070-2071
  byte   MCRPHO07 2072-2073
  byte   MCDHMO31 2074-2075
  byte   MCDHMO42 2076-2077
  byte   MCDHMO07 2078-2079
  byte   MCDMC31 2080-2081
  byte   MCDMC42 2082-2083
  byte   MCDMC07 2084-2085
  byte   PRVHMO31 2086-2087
  byte   PRVHMO42 2088-2089
  byte   PRVHMO07 2090-2091
  byte   PRVMNC31 2092-2093
  byte   PRVMNC42 2094-2095
  byte   PRVMNC07 2096-2097
  byte   PRVDRL31 2098-2099
  byte   PRVDRL42 2100-2101
  byte   PRVDRL07 2102-2103
  byte   PHMONP31 2104-2105
  byte   PHMONP42 2106-2107
  byte   PHMONP07 2108-2109
  byte   PMNCNP31 2110-2111
  byte   PMNCNP42 2112-2113
  byte   PMNCNP07 2114-2115
  byte   PRDRNP31 2116-2117
  byte   PRDRNP42 2118-2119
  byte   PRDRNP07 2120-2121
  byte   PREVCOVR 2122-2123
  byte   COVRMM 2124-2125
  int    COVRYY 2126-2129
  byte   WASESTB 2130-2131
  byte   WASMCARE 2132-2133
  byte   WASMCAID 2134-2135
  byte   WASCHAMP 2136-2137
  byte   WASVA 2138-2139
  byte   WASPRIV 2140-2141
  byte   WASOTGOV 2142-2143
  byte   WASAFDC 2144-2145
  byte   WASSSI 2146-2147
  byte   WASSTAT1 2148-2149
  byte   WASSTAT2 2150-2151
  byte   WASSTAT3 2152-2153
  byte   WASSTAT4 2154-2155
  byte   WASOTHER 2156-2157
  byte   NOINSBEF 2158-2159
  byte   NOINSTM 2160-2161
  byte   NOINUNIT 2162-2163
  byte   MORECOVR 2164-2165
  byte   INSENDMM 2166-2167
  int    INSENDYY 2168-2171
  byte   TRICR31X 2172-2173
  byte   TRICR42X 2174-2175
  byte   TRICR53X 2176-2177
  byte   TRICR07X 2178-2179
  byte   TRIAT31X 2180-2181
  byte   TRIAT42X 2182-2183
  byte   TRIAT53X 2184-2185
  byte   TRIAT07X 2186-2187
  byte   MCAID31 2188-2189
  byte   MCAID42 2190-2191
  byte   MCAID53 2192-2193
  byte   MCAID07 2194-2195
  byte   MCAID31X 2196-2197
  byte   MCAID42X 2198-2199
  byte   MCAID53X 2200-2201
  byte   MCAID07X 2202-2203
  byte   MCARE31 2204-2205
  byte   MCARE42 2206-2207
  byte   MCARE53 2208-2209
  byte   MCARE07 2210-2211
  byte   MCARE31X 2212-2213
  byte   MCARE42X 2214-2215
  byte   MCARE53X 2216-2217
  byte   MCARE07X 2218-2219
  byte   MCDAT31X 2220-2221
  byte   MCDAT42X 2222-2223
  byte   MCDAT53X 2224-2225
  byte   MCDAT07X 2226-2227
  byte   OTPAAT31 2228-2229
  byte   OTPAAT42 2230-2231
  byte   OTPAAT53 2232-2233
  byte   OTPAAT07 2234-2235
  byte   OTPBAT31 2236-2237
  byte   OTPBAT42 2238-2239
  byte   OTPBAT53 2240-2241
  byte   OTPBAT07 2242-2243
  byte   OTPUBA31 2244-2245
  byte   OTPUBA42 2246-2247
  byte   OTPUBA53 2248-2249
  byte   OTPUBA07 2250-2251
  byte   OTPUBB31 2252-2253
  byte   OTPUBB42 2254-2255
  byte   OTPUBB53 2256-2257
  byte   OTPUBB07 2258-2259
  byte   PRIDK31 2260-2261
  byte   PRIDK42 2262-2263
  byte   PRIDK53 2264-2265
  byte   PRIDK07 2266-2267
  byte   PRIEU31 2268-2269
  byte   PRIEU42 2270-2271
  byte   PRIEU53 2272-2273
  byte   PRIEU07 2274-2275
  byte   PRING31 2276-2277
  byte   PRING42 2278-2279
  byte   PRING53 2280-2281
  byte   PRING07 2282-2283
  byte   PRIOG31 2284-2285
  byte   PRIOG42 2286-2287
  byte   PRIOG53 2288-2289
  byte   PRIOG07 2290-2291
  byte   PRIS31 2292-2293
  byte   PRIS42 2294-2295
  byte   PRIS53 2296-2297
  byte   PRIS07 2298-2299
  byte   PRIV31 2300-2301
  byte   PRIV42 2302-2303
  byte   PRIV53 2304-2305
  byte   PRIV07 2306-2307
  byte   PRIVAT31 2308-2309
  byte   PRIVAT42 2310-2311
  byte   PRIVAT53 2312-2313
  byte   PRIVAT07 2314-2315
  byte   PROUT31 2316-2317
  byte   PROUT42 2318-2319
  byte   PROUT53 2320-2321
  byte   PROUT07 2322-2323
  byte   PUB31X 2324-2325
  byte   PUB42X 2326-2327
  byte   PUB53X 2328-2329
  byte   PUB07X 2330-2331
  byte   PUBAT31X 2332-2333
  byte   PUBAT42X 2334-2335
  byte   PUBAT53X 2336-2337
  byte   PUBAT07X 2338-2339
  byte   INS31X 2340-2341
  byte   INS42X 2342-2343
  byte   INS53X 2344-2345
  byte   INS07X 2346-2347
  byte   INSAT31X 2348-2349
  byte   INSAT42X 2350-2351
  byte   INSAT53X 2352-2353
  byte   INSAT07X 2354-2355
  byte   STAPR31 2356-2357
  byte   STAPR42 2358-2359
  byte   STAPR53 2360-2361
  byte   STAPR07 2362-2363
  byte   STPRAT31 2364-2365
  byte   STPRAT42 2366-2367
  byte   STPRAT53 2368-2369
  byte   STPRAT07 2370-2371
  byte   EVRUNINS 2372-2372
  byte   EVRUNAT 2373-2373
  byte   DENTIN31 2374-2375
  byte   DENTIN42 2376-2377
  byte   DENTIN53 2378-2379
  byte   DNTINS31 2380-2381
  byte   DNTINS07 2382-2383
  byte   PMEDIN31 2384-2385
  byte   PMEDIN42 2386-2387
  byte   PMEDIN53 2388-2389
  byte   PMDINS31 2390-2391
  byte   PMDINS07 2392-2393
  byte   PMEDUP31 2394-2395
  byte   PMEDUP42 2396-2397
  byte   PMEDUP53 2398-2399
  byte   PMEDPY31 2400-2401
  byte   PMEDPY42 2402-2403
  byte   PMEDPY53 2404-2405
  int    PMEDOP31 2406-2409
  int    PMEDOP42 2410-2413
  int    PMEDOP53 2414-2417
  byte   GDCPBM42 2418-2419
  byte   APRTRM42 2420-2421
  byte   APRDLM42 2422-2423
  byte   LKINFM42 2424-2425
  byte   PBINFM42 2426-2427
  byte   CSTSVM42 2428-2429
  byte   PBSVCM42 2430-2431
  byte   PPRWKM42 2432-2433
  byte   PBPWKM42 2434-2435
  byte   RTPLNM42 2436-2437
  byte   GDCPBT42 2438-2439
  byte   APRTRT42 2440-2441
  byte   APRDLT42 2442-2443
  byte   LKINFT42 2444-2445
  byte   PBINFT42 2446-2447
  byte   CSTSVT42 2448-2449
  byte   PBSVCT42 2450-2451
  byte   PPRWKT42 2452-2453
  byte   PBPWKT42 2454-2455
  byte   RTPLNT42 2456-2457
  long   TOTTCH07 2458-2464
  long   TOTEXP07 2465-2470
  long   TOTSLF07 2471-2475
  long   TOTMCR07 2476-2481
  long   TOTMCD07 2482-2487
  long   TOTPRV07 2488-2493
  long   TOTVA07 2494-2498
  long   TOTTRI07 2499-2503
  long   TOTOFD07 2504-2508
  long   TOTSTL07 2509-2513
  long   TOTWCP07 2514-2519
  long   TOTOPR07 2520-2525
  long   TOTOPU07 2526-2531
  long   TOTOSR07 2532-2537
  int    OBTOTV07 2538-2540
  long   OBVTCH07 2541-2546
  long   OBVEXP07 2547-2552
  long   OBVSLF07 2553-2557
  long   OBVMCR07 2558-2562
  long   OBVMCD07 2563-2567
  long   OBVPRV07 2568-2573
  long   OBVVA07 2574-2578
  long   OBVTRI07 2579-2583
  long   OBVOFD07 2584-2588
  long   OBVSTL07 2589-2593
  long   OBVWCP07 2594-2598
  long   OBVOPR07 2599-2603
  long   OBVOPU07 2604-2608
  long   OBVOSR07 2609-2613
  int    OBDRV07 2614-2616
  long   OBDTCH07 2617-2622
  long   OBDEXP07 2623-2628
  long   OBDSLF07 2629-2633
  long   OBDMCR07 2634-2638
  long   OBDMCD07 2639-2643
  long   OBDPRV07 2644-2649
  long   OBDVA07 2650-2654
  long   OBDTRI07 2655-2659
  long   OBDOFD07 2660-2664
  long   OBDSTL07 2665-2669
  long   OBDWCP07 2670-2674
  long   OBDOPR07 2675-2679
  int    OBDOPU07 2680-2683
  long   OBDOSR07 2684-2688
  int    OBOTHV07 2689-2691
  long   OBOTCH07 2692-2697
  long   OBOEXP07 2698-2703
  long   OBOSLF07 2704-2708
  long   OBOMCR07 2709-2713
  long   OBOMCD07 2714-2718
  long   OBOPRV07 2719-2724
  long   OBOVA07 2725-2729
  int    OBOTRI07 2730-2733
  long   OBOOFD07 2734-2738
  long   OBOSTL07 2739-2743
  long   OBOWCP07 2744-2748
  long   OBOOPR07 2749-2753
  long   OBOOPU07 2754-2758
  long   OBOOSR07 2759-2763
  int    OBCHIR07 2764-2766
  long   OBCTCH07 2767-2771
  long   OBCEXP07 2772-2776
  long   OBCSLF07 2777-2781
  int    OBCMCR07 2782-2785
  int    OBCMCD07 2786-2789
  int    OBCPRV07 2790-2793
  byte   OBCVA07 2794-2795
  int    OBCTRI07 2796-2798
  byte   OBCOFD07 2799-2799
  int    OBCSTL07 2800-2803
  int    OBCWCP07 2804-2807
  int    OBCOPR07 2808-2811
  int    OBCOPU07 2812-2814
  int    OBCOSR07 2815-2818
  int    OBNURS07 2819-2821
  long   OBNTCH07 2822-2827
  long   OBNEXP07 2828-2833
  int    OBNSLF07 2834-2837
  long   OBNMCR07 2838-2842
  long   OBNMCD07 2843-2847
  long   OBNPRV07 2848-2853
  int    OBNVA07 2854-2857
  int    OBNTRI07 2858-2861
  int    OBNOFD07 2862-2864
  int    OBNSTL07 2865-2868
  int    OBNWCP07 2869-2871
  int    OBNOPR07 2872-2875
  long   OBNOPU07 2876-2880
  int    OBNOSR07 2881-2884
  byte   OBOPTO07 2885-2886
  int    OBETCH07 2887-2890
  int    OBEEXP07 2891-2894
  int    OBESLF07 2895-2898
  int    OBEMCR07 2899-2901
  int    OBEMCD07 2902-2905
  int    OBEPRV07 2906-2909
  int    OBEVA07 2910-2912
  int    OBETRI07 2913-2915
  int    OBEOFD07 2916-2918
  int    OBESTL07 2919-2922
  byte   OBEWCP07 2923-2924
  int    OBEOPR07 2925-2928
  byte   OBEOPU07 2929-2930
  int    OBEOSR07 2931-2933
  byte   OBASST07 2934-2935
  long   OBATCH07 2936-2940
  long   OBAEXP07 2941-2945
  int    OBASLF07 2946-2949
  int    OBAMCR07 2950-2953
  int    OBAMCD07 2954-2957
  long   OBAPRV07 2958-2962
  int    OBAVA07 2963-2966
  int    OBATRI07 2967-2969
  int    OBAOFD07 2970-2972
  int    OBASTL07 2973-2975
  int    OBAWCP07 2976-2978
  int    OBAOPR07 2979-2982
  int    OBAOPU07 2983-2985
  int    OBAOSR07 2986-2988
  byte   OBTHER07 2989-2990
  long   OBTTCH07 2991-2996
  long   OBTEXP07 2997-3002
  int    OBTSLF07 3003-3006
  int    OBTMCR07 3007-3010
  int    OBTMCD07 3011-3014
  long   OBTPRV07 3015-3020
  int    OBTVA07 3021-3024
  int    OBTTRI07 3025-3028
  int    OBTOFD07 3029-3031
  int    OBTSTL07 3032-3035
  long   OBTWCP07 3036-3040
  int    OBTOPR07 3041-3044
  int    OBTOPU07 3045-3047
  int    OBTOSR07 3048-3051
  int    OPTOTV07 3052-3054
  long   OPTTCH07 3055-3060
  long   OPTEXP07 3061-3066
  long   OPTSLF07 3067-3071
  long   OPTMCR07 3072-3076
  long   OPTMCD07 3077-3081
  long   OPTPRV07 3082-3087
  long   OPTVA07 3088-3092
  int    OPTTRI07 3093-3096
  int    OPTOFD07 3097-3100
  long   OPTSTL07 3101-3105
  long   OPTWCP07 3106-3110
  long   OPTOPR07 3111-3115
  int    OPTOPU07 3116-3119
  long   OPTOSR07 3120-3124
  long   OPFTCH07 3125-3130
  long   OPFEXP07 3131-3136
  long   OPFSLF07 3137-3141
  long   OPFMCR07 3142-3146
  long   OPFMCD07 3147-3151
  long   OPFPRV07 3152-3157
  long   OPFVA07 3158-3162
  int    OPFTRI07 3163-3166
  int    OPFOFD07 3167-3170
  long   OPFSTL07 3171-3175
  long   OPFWCP07 3176-3180
  long   OPFOPR07 3181-3185
  int    OPFOPU07 3186-3189
  long   OPFOSR07 3190-3194
  long   OPDEXP07 3195-3199
  long   OPDTCH07 3200-3204
  int    OPDSLF07 3205-3208
  int    OPDMCR07 3209-3212
  int    OPDMCD07 3213-3216
  int    OPDPRV07 3217-3220
  int    OPDVA07 3221-3223
  int    OPDTRI07 3224-3226
  int    OPDOFD07 3227-3229
  int    OPDSTL07 3230-3232
  long   OPDWCP07 3233-3237
  int    OPDOPR07 3238-3241
  int    OPDOPU07 3242-3244
  int    OPDOSR07 3245-3248
  byte   OPDRV07 3249-3250
  long   OPVTCH07 3251-3256
  long   OPVEXP07 3257-3261
  long   OPVSLF07 3262-3266
  long   OPVMCR07 3267-3271
  int    OPVMCD07 3272-3275
  long   OPVPRV07 3276-3280
  long   OPVVA07 3281-3285
  int    OPVTRI07 3286-3289
  int    OPVOFD07 3290-3293
  long   OPVSTL07 3294-3298
  long   OPVWCP07 3299-3303
  long   OPVOPR07 3304-3308
  int    OPVOPU07 3309-3312
  long   OPVOSR07 3313-3317
  long   OPSEXP07 3318-3322
  long   OPSTCH07 3323-3327
  int    OPSSLF07 3328-3331
  int    OPSMCR07 3332-3335
  int    OPSMCD07 3336-3339
  int    OPSPRV07 3340-3343
  int    OPSVA07 3344-3346
  int    OPSTRI07 3347-3349
  int    OPSOFD07 3350-3352
  int    OPSSTL07 3353-3355
  long   OPSWCP07 3356-3360
  int    OPSOPR07 3361-3364
  int    OPSOPU07 3365-3367
  int    OPSOSR07 3368-3371
  int    OPOTHV07 3372-3374
  long   OPOTCH07 3375-3380
  long   OPOEXP07 3381-3386
  int    OPOSLF07 3387-3390
  long   OPOMCR07 3391-3395
  long   OPOMCD07 3396-3400
  long   OPOPRV07 3401-3406
  int    OPOVA07 3407-3410
  int    OPOTRI07 3411-3413
  int    OPOOFD07 3414-3417
  long   OPOSTL07 3418-3422
  int    OPOWCP07 3423-3426
  int    OPOOPR07 3427-3430
  int    OPOOPU07 3431-3434
  int    OPOOSR07 3435-3438
  int    OPPEXP07 3439-3442
  long   OPPTCH07 3443-3447
  int    OPPSLF07 3448-3450
  int    OPPMCR07 3451-3454
  int    OPPMCD07 3455-3458
  int    OPPPRV07 3459-3462
  int    OPPVA07 3463-3465
  int    OPPTRI07 3466-3468
  byte   OPPOFD07 3469-3469
  int    OPPSTL07 3470-3472
  int    OPPWCP07 3473-3476
  int    OPPOPR07 3477-3480
  int    OPPOPU07 3481-3483
  int    OPPOSR07 3484-3486
  int    AMCHIR07 3487-3489
  long   AMCTCH07 3490-3494
  long   AMCEXP07 3495-3499
  long   AMCSLF07 3500-3504
  int    AMCMCR07 3505-3508
  int    AMCMCD07 3509-3512
  int    AMCPRV07 3513-3516
  byte   AMCVA07 3517-3518
  int    AMCTRI07 3519-3521
  byte   AMCOFD07 3522-3522
  int    AMCSTL07 3523-3526
  int    AMCWCP07 3527-3530
  int    AMCOPR07 3531-3534
  int    AMCOPU07 3535-3537
  int    AMCOSR07 3538-3541
  int    AMNURS07 3542-3544
  long   AMNTCH07 3545-3550
  long   AMNEXP07 3551-3556
  int    AMNSLF07 3557-3560
  long   AMNMCR07 3561-3565
  long   AMNMCD07 3566-3570
  long   AMNPRV07 3571-3576
  int    AMNVA07 3577-3580
  int    AMNTRI07 3581-3584
  int    AMNOFD07 3585-3587
  int    AMNSTL07 3588-3591
  int    AMNWCP07 3592-3595
  long   AMNOPR07 3596-3600
  long   AMNOPU07 3601-3605
  int    AMNOSR07 3606-3609
  byte   AMOPTO07 3610-3611
  int    AMETCH07 3612-3615
  int    AMEEXP07 3616-3619
  int    AMESLF07 3620-3623
  int    AMEMCR07 3624-3626
  int    AMEMCD07 3627-3630
  int    AMEPRV07 3631-3634
  int    AMEVA07 3635-3637
  int    AMETRI07 3638-3640
  int    AMEOFD07 3641-3643
  int    AMESTL07 3644-3647
  byte   AMEWCP07 3648-3649
  int    AMEOPR07 3650-3653
  byte   AMEOPU07 3654-3655
  int    AMEOSR07 3656-3658
  byte   AMASST07 3659-3660
  long   AMATCH07 3661-3665
  long   AMAEXP07 3666-3670
  int    AMASLF07 3671-3674
  int    AMAMCR07 3675-3678
  int    AMAMCD07 3679-3682
  long   AMAPRV07 3683-3687
  int    AMAVA07 3688-3691
  int    AMATRI07 3692-3694
  int    AMAOFD07 3695-3697
  int    AMASTL07 3698-3700
  int    AMAWCP07 3701-3703
  int    AMAOPR07 3704-3707
  int    AMAOPU07 3708-3710
  int    AMAOSR07 3711-3713
  byte   AMTHER07 3714-3715
  long   AMTTCH07 3716-3721
  long   AMTEXP07 3722-3727
  int    AMTSLF07 3728-3731
  long   AMTMCR07 3732-3736
  int    AMTMCD07 3737-3740
  long   AMTPRV07 3741-3746
  int    AMTVA07 3747-3750
  int    AMTTRI07 3751-3754
  int    AMTOFD07 3755-3757
  int    AMTSTL07 3758-3761
  long   AMTWCP07 3762-3766
  int    AMTOPR07 3767-3770
  int    AMTOPU07 3771-3774
  int    AMTOSR07 3775-3778
  byte   AMTOTC07 3779-3780
  byte   AMDRC07 3781-3782
  byte   ERTOT07 3783-3784
  long   ERTTCH07 3785-3790
  long   ERTEXP07 3791-3795
  long   ERTSLF07 3796-3800
  long   ERTMCR07 3801-3805
  int    ERTMCD07 3806-3809
  long   ERTPRV07 3810-3814
  int    ERTVA07 3815-3818
  int    ERTTRI07 3819-3822
  int    ERTOFD07 3823-3826
  int    ERTSTL07 3827-3830
  int    ERTWCP07 3831-3834
  int    ERTOPR07 3835-3838
  long   ERTOPU07 3839-3843
  int    ERTOSR07 3844-3847
  long   ERFTCH07 3848-3852
  long   ERFEXP07 3853-3857
  long   ERFSLF07 3858-3862
  long   ERFMCR07 3863-3867
  int    ERFMCD07 3868-3871
  long   ERFPRV07 3872-3876
  int    ERFVA07 3877-3880
  int    ERFTRI07 3881-3884
  int    ERFOFD07 3885-3888
  int    ERFSTL07 3889-3892
  int    ERFWCP07 3893-3896
  int    ERFOPR07 3897-3900
  long   ERFOPU07 3901-3905
  int    ERFOSR07 3906-3909
  int    ERDEXP07 3910-3913
  int    ERDTCH07 3914-3917
  int    ERDSLF07 3918-3921
  int    ERDMCR07 3922-3925
  int    ERDMCD07 3926-3929
  int    ERDPRV07 3930-3933
  int    ERDVA07 3934-3936
  int    ERDTRI07 3937-3939
  byte   ERDOFD07 3940-3941
  int    ERDSTL07 3942-3944
  int    ERDWCP07 3945-3948
  int    ERDOPR07 3949-3952
  int    ERDOPU07 3953-3955
  int    ERDOSR07 3956-3958
  byte   IPZERO07 3959-3959
  long   ZIFTCH07 3960-3965
  long   ZIFEXP07 3966-3970
  int    ZIFSLF07 3971-3973
  long   ZIFMCR07 3974-3978
  int    ZIFMCD07 3979-3982
  long   ZIFPRV07 3983-3987
  int    ZIFVA07 3988-3990
  int    ZIFTRI07 3991-3994
  byte   ZIFOFD07 3995-3995
  byte   ZIFSTL07 3996-3996
  byte   ZIFWCP07 3997-3997
  int    ZIFOPR07 3998-4001
  int    ZIFOPU07 4002-4005
  int    ZIFOSR07 4006-4009
  int    ZIDEXP07 4010-4013
  long   ZIDTCH07 4014-4018
  int    ZIDSLF07 4019-4021
  int    ZIDMCR07 4022-4025
  int    ZIDMCD07 4026-4029
  int    ZIDPRV07 4030-4033
  byte   ZIDVA07 4034-4034
  int    ZIDTRI07 4035-4037
  byte   ZIDOFD07 4038-4038
  byte   ZIDSTL07 4039-4039
  int    ZIDWCP07 4040-4042
  int    ZIDOPR07 4043-4045
  int    ZIDOPU07 4046-4048
  int    ZIDOSR07 4049-4052
  byte   IPDIS07 4053-4054
  long   IPTEXP07 4055-4060
  long   IPTTCH07 4061-4067
  long   IPTSLF07 4068-4072
  long   IPTMCR07 4073-4078
  long   IPTMCD07 4079-4084
  long   IPTPRV07 4085-4090
  long   IPTVA07 4091-4095
  long   IPTTRI07 4096-4100
  long   IPTOFD07 4101-4105
  long   IPTSTL07 4106-4110
  long   IPTWCP07 4111-4116
  long   IPTOPR07 4117-4121
  long   IPTOPU07 4122-4127
  long   IPTOSR07 4128-4133
  long   IPFEXP07 4134-4139
  long   IPFTCH07 4140-4146
  long   IPFSLF07 4147-4151
  long   IPFMCR07 4152-4157
  long   IPFMCD07 4158-4163
  long   IPFPRV07 4164-4169
  long   IPFVA07 4170-4174
  long   IPFTRI07 4175-4179
  long   IPFOFD07 4180-4184
  long   IPFSTL07 4185-4189
  long   IPFWCP07 4190-4195
  long   IPFOPR07 4196-4200
  long   IPFOPU07 4201-4206
  long   IPFOSR07 4207-4212
  long   IPDEXP07 4213-4217
  long   IPDTCH07 4218-4222
  int    IPDSLF07 4223-4226
  long   IPDMCR07 4227-4231
  long   IPDMCD07 4232-4236
  long   IPDPRV07 4237-4241
  int    IPDVA07 4242-4245
  int    IPDTRI07 4246-4249
  byte   IPDOFD07 4250-4251
  int    IPDSTL07 4252-4255
  long   IPDWCP07 4256-4260
  long   IPDOPR07 4261-4265
  int    IPDOPU07 4266-4269
  long   IPDOSR07 4270-4274
  int    IPNGTD07 4275-4277
  byte   DVTOT07 4278-4279
  long   DVTTCH07 4280-4284
  long   DVTEXP07 4285-4289
  long   DVTSLF07 4290-4294
  long   DVTMCR07 4295-4299
  long   DVTMCD07 4300-4304
  long   DVTPRV07 4305-4309
  int    DVTVA07 4310-4313
  int    DVTTRI07 4314-4317
  int    DVTOFD07 4318-4320
  int    DVTSTL07 4321-4324
  int    DVTWCP07 4325-4327
  long   DVTOPR07 4328-4332
  int    DVTOPU07 4333-4336
  int    DVTOSR07 4337-4340
  byte   DVGEN07 4341-4342
  long   DVGTCH07 4343-4347
  long   DVGEXP07 4348-4352
  long   DVGSLF07 4353-4357
  long   DVGMCR07 4358-4362
  int    DVGMCD07 4363-4366
  long   DVGPRV07 4367-4371
  int    DVGVA07 4372-4375
  int    DVGTRI07 4376-4379
  int    DVGOFD07 4380-4382
  int    DVGSTL07 4383-4386
  int    DVGWCP07 4387-4389
  int    DVGOPR07 4390-4393
  int    DVGOPU07 4394-4396
  int    DVGOSR07 4397-4400
  byte   DVORTH07 4401-4402
  long   DVOTCH07 4403-4407
  long   DVOEXP07 4408-4412
  long   DVOSLF07 4413-4417
  byte   DVOMCR07 4418-4418
  long   DVOMCD07 4419-4423
  long   DVOPRV07 4424-4428
  int    DVOVA07 4429-4432
  int    DVOTRI07 4433-4436
  byte   DVOOFD07 4437-4437
  int    DVOSTL07 4438-4441
  byte   DVOWCP07 4442-4442
  int    DVOOPR07 4443-4446
  int    DVOOPU07 4447-4450
  int    DVOOSR07 4451-4454
  int    HHTOTD07 4455-4458
  int    HHAGD07 4459-4461
  long   HHATCH07 4462-4467
  long   HHAEXP07 4468-4473
  long   HHASLF07 4474-4478
  long   HHAMCR07 4479-4483
  long   HHAMCD07 4484-4489
  long   HHAPRV07 4490-4494
  int    HHAVA07 4495-4498
  int    HHATRI07 4499-4502
  int    HHAOFD07 4503-4506
  long   HHASTL07 4507-4511
  int    HHAWCP07 4512-4515
  int    HHAOPR07 4516-4519
  int    HHAOPU07 4520-4522
  int    HHAOSR07 4523-4526
  int    HHINDD07 4527-4530
  long   HHNTCH07 4531-4535
  long   HHNEXP07 4536-4540
  long   HHNSLF07 4541-4545
  int    HHNMCR07 4546-4548
  int    HHNMCD07 4549-4552
  long   HHNPRV07 4553-4557
  int    HHNVA07 4558-4560
  byte   HHNTRI07 4561-4562
  byte   HHNOFD07 4563-4563
  int    HHNSTL07 4564-4567
  byte   HHNWCP07 4568-4568
  int    HHNOPR07 4569-4572
  byte   HHNOPU07 4573-4573
  int    HHNOSR07 4574-4577
  int    HHINFD07 4578-4580
  int    VISEXP07 4581-4584
  int    VISTCH07 4585-4588
  int    VISSLF07 4589-4592
  int    VISMCR07 4593-4595
  int    VISMCD07 4596-4598
  int    VISPRV07 4599-4602
  int    VISVA07 4603-4606
  int    VISTRI07 4607-4609
  int    VISOFD07 4610-4612
  int    VISSTL07 4613-4615
  int    VISWCP07 4616-4618
  int    VISOPR07 4619-4621
  int    VISOPU07 4622-4624
  int    VISOSR07 4625-4628
  long   OTHTCH07 4629-4633
  long   OTHEXP07 4634-4638
  long   OTHSLF07 4639-4643
  int    OTHMCR07 4644-4647
  long   OTHMCD07 4648-4652
  long   OTHPRV07 4653-4657
  int    OTHVA07 4658-4661
  int    OTHTRI07 4662-4665
  byte   OTHOFD07 4666-4666
  int    OTHSTL07 4667-4670
  int    OTHWCP07 4671-4674
  int    OTHOPR07 4675-4677
  byte   OTHOPU07 4678-4679
  int    OTHOSR07 4680-4683
  int    RXTOT07 4684-4686
  long   RXEXP07 4687-4691
  long   RXSLF07 4692-4696
  long   RXMCR07 4697-4701
  long   RXMCD07 4702-4706
  long   RXPRV07 4707-4711
  long   RXVA07 4712-4716
  int    RXTRI07 4717-4720
  int    RXOFD07 4721-4724
  int    RXSTL07 4725-4728
  int    RXWCP07 4729-4732
  long   RXOPR07 4733-4737
  int    RXOPU07 4738-4741
  int    RXOSR07 4742-4744
  long   TOTPTR07 4745-4750
  long   TOTOTH07 4751-4756
  long   OBVPTR07 4757-4762
  long   OBVOTH07 4763-4767
  long   OBDPTR07 4768-4773
  long   OBDOTH07 4774-4778
  long   OBOPTR07 4779-4784
  long   OBOOTH07 4785-4789
  int    OBCPTR07 4790-4793
  int    OBCOTH07 4794-4797
  long   OBNPTR07 4798-4803
  long   OBNOTH07 4804-4808
  int    OBEPTR07 4809-4812
  int    OBEOTH07 4813-4816
  long   OBAPTR07 4817-4821
  int    OBAOTH07 4822-4825
  long   OBTPTR07 4826-4831
  int    OBTOTH07 4832-4835
  long   OPTPTR07 4836-4841
  long   OPTOTH07 4842-4846
  long   OPFPTR07 4847-4852
  long   OPFOTH07 4853-4857
  int    OPDPTR07 4858-4861
  int    OPDOTH07 4862-4865
  long   OPVPTR07 4866-4870
  long   OPVOTH07 4871-4875
  int    OPSPTR07 4876-4879
  int    OPSOTH07 4880-4883
  long   OPOPTR07 4884-4889
  long   OPOOTH07 4890-4894
  int    OPPPTR07 4895-4898
  int    OPPOTH07 4899-4902
  int    AMCPTR07 4903-4906
  int    AMCOTH07 4907-4910
  long   AMNPTR07 4911-4916
  long   AMNOTH07 4917-4921
  int    AMEPTR07 4922-4925
  int    AMEOTH07 4926-4929
  long   AMAPTR07 4930-4934
  int    AMAOTH07 4935-4938
  long   AMTPTR07 4939-4944
  int    AMTOTH07 4945-4948
  long   ERTPTR07 4949-4953
  long   ERTOTH07 4954-4958
  long   ERFPTR07 4959-4963
  long   ERFOTH07 4964-4968
  int    ERDPTR07 4969-4972
  int    ERDOTH07 4973-4976
  long   ZIFPTR07 4977-4981
  int    ZIFOTH07 4982-4985
  int    ZIDPTR07 4986-4989
  int    ZIDOTH07 4990-4993
  long   IPTPTR07 4994-4999
  long   IPTOTH07 5000-5005
  long   IPFPTR07 5006-5011
  long   IPFOTH07 5012-5017
  long   IPDPTR07 5018-5022
  long   IPDOTH07 5023-5027
  long   DVTPTR07 5028-5032
  long   DVTOTH07 5033-5037
  long   DVGPTR07 5038-5042
  int    DVGOTH07 5043-5046
  long   DVOPTR07 5047-5051
  int    DVOOTH07 5052-5055
  long   HHAPTR07 5056-5060
  long   HHAOTH07 5061-5065
  long   HHNPTR07 5066-5070
  int    HHNOTH07 5071-5074
  int    VISPTR07 5075-5078
  int    VISOTH07 5079-5082
  long   OTHPTR07 5083-5087
  int    OTHOTH07 5088-5091
  long   RXPTR07 5092-5096
  long   RXOTH07 5097-5101
  double PERWT07F 5102-5113
  double FAMWT07F 5114-5125
  double FAMWT07C 5126-5137
  double SAQWT07F 5138-5149
  double DIABW07F 5150-5161
  int    VARSTR 5162-5165
  byte   VARPSU 5166-5166
using H113.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID07 "FAMILY ID (STUDENT MERGED IN) - 12/31/07";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-07";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-07";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR07 "RU LETTER AS OF 12/31/07";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE07 "RU SIZE AS OF 12/31/07";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS07 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/07";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE07 "RU SIZE INCLUDING STUDENT AS OF 12/31/07";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION07 "CENSUS REGION AS OF 12/31/07";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA07 "MSA AS OF 12/31/07";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS07 "REFERENCE PERSON AS OF 12/31/07";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP07 "1ST RESPONDENT INDICATOR AS OF 12/31/07";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY07 "WAS RESPONDENT A PROXY AS OF 12/31/07";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM07 "2007 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY07 "2007 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP07 "INSCOPE - R5/3 START THROUGH 12/31/07";
label variable INSC1231 "INSCOPE STATUS ON 12/31/07";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2007";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND07 "ELIGIBILITY STATUS AS OF 12/31/07";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE07X "AGE AS OF 12/31/07 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY07X "MARITAL STATUS-12/31/07 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID07 "SPOUSE ID - 12/31/07";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN07 "MARITAL STATUS W/SPOUSE PRESENT-12/31/07";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU07X "STUDENT STATUS IF AGES 17-23 - 12/31/07";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL07X "RELATION TO REF PERS-12/31/07 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS07 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC07 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR07 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL07 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT07 "PERSON S FILING STATUS";
label variable FILER07 "PRIMARY OR SECONDARY FILER";
label variable JTINRU07 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID07 "PID OF SECONDARY FILER";
label variable CLMDEP07 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT07 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU07 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD07 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM07 "TAX FORM PERSON WILL FILE";
label variable DEDUCT07 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED07 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP07 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT07 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST07 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN07 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL07 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP07X "PERSON S TOTAL INCOME";
label variable FAMINC07 "FAMILY S TOTAL INCOME";
label variable POVCAT07 "FAMILY INC AS % OF POVERTY LINE - CATEGORICAL";
label variable POVLEV07 "FAMILY INC AS % OF POVERTY LINE - CONTINUOUS";
label variable WAGEP07X "PERSON S WAGE INCOME";
label variable WAGIMP07 "WAGE IMPUTATION FLAG";
label variable BUSNP07X "PERSON S BUSINESS INCOME";
label variable BUSIMP07 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP07X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP07 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP07X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP07 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP07X "PERSON S INTEREST INCOME";
label variable INTIMP07 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP07X "PERSON S DIVIDEND INCOME";
label variable DIVIMP07 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP07X "PERSON S SALES INCOME";
label variable SALIMP07 "SALES INCOME IMPUTATION FLAG";
label variable PENSP07X "PERSON S PENSION INCOME";
label variable PENIMP07 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP07X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP07 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP07X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP07 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP07X "PERSON S VETERAN S INCOME";
label variable VETIMP07 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP07X "PERSON S IRA INCOME";
label variable IRAIMP07 "IRA INCOME IMPUTATION FLAG";
label variable REFDP07X "PERSON S REFUND INCOME";
label variable REFIMP07 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP07X "PERSON S ALIMONY INCOME";
label variable ALIIMP07 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP07X "PERSON S CHILD SUPPORT";
label variable CHLIMP07 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP07X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP07 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP07X "PERSON S SSI";
label variable SSIIMP07 "SSI IMPUTATION FLAG";
label variable PUBP07X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP07 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP07X "PERSON S OTHER INCOME";
label variable OTHIMP07 "OTHER INCOME IMPUTATION FLAG";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHLAGE "HOW OLD WHEN DIAG W/ HGH CHOL(>17)";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM07 "ANY LIMITATION IN P11R3,4,5/P12R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHNECP42 "CAHPS:12MOS:PROB GET NEC CARE(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHPRRE42 "CAHPS:12MOS:PRB W/RFR TO SPEC(0-17)R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU VACINATION (>17)-RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADNECP42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM SEEING SPECIALIST";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2007";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2007";
label variable DSEY0853 "DCS: DILATED EYE EXAM IN 2008";
label variable DSEY0753 "DCS: DILATED EYE EXAM IN 2007";
label variable DSEY0653 "DCS: DILATED EYE EXAM IN 2006";
label variable DSEB0653 "DCS: DILATED EYE EXAM BEFORE 2006";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable PHONE53 "DCS: LEARNED DIAB CARE FROM PHONE CALL";
label variable NURSE53 "DCS: LEARNED DIAB CARE FROM NURSE";
label variable VISIT53 "DCS: LEARNED DIAB CARE FROM HOME VISIT";
label variable REFER53 "DCS: LEARNED DIAB CARE FROM SPECIALIST";
label variable CHLCHK53 "DCS: HOW LONG SINCE CHOLESTEROL CHECK";
label variable FLSHOT53 "DCS: HOW LONG SINCE LAST FLU VACCINATION";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGHME42 "AC02 HH COMFORTABLE SPEAKNG ENGLISH-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R4/2";
label variable USLIVE42 "AC04 # YRS PERSON LIVED IN US-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable FACLPR42 "AC10 DOES PERS SEE PARTICULAR PROV-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/07";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable TRIJA07X "COVERED BY TRICARE/CHAMPVA IN JAN07 (ED)";
label variable TRIFE07X "COVERED BY TRICARE/CHAMPVA IN FEB07 (ED)";
label variable TRIMA07X "COVERED BY TRICARE/CHAMPVA IN MAR07 (ED)";
label variable TRIAP07X "COVERED BY TRICARE/CHAMPVA IN APR07 (ED)";
label variable TRIMY07X "COVERED BY TRICARE/CHAMPVA IN MAY07 (ED)";
label variable TRIJU07X "COVERED BY TRICARE/CHAMPVA IN JUN07 (ED)";
label variable TRIJL07X "COVERED BY TRICARE/CHAMPVA IN JUL07 (ED)";
label variable TRIAU07X "COVERED BY TRICARE/CHAMPVA IN AUG07 (ED)";
label variable TRISE07X "COVERED BY TRICARE/CHAMPVA IN SEP07 (ED)";
label variable TRIOC07X "COVERED BY TRICARE/CHAMPVA IN OCT07 (ED)";
label variable TRINO07X "COVERED BY TRICARE/CHAMPVA IN NOV07 (ED)";
label variable TRIDE07X "COVERED BY TRICARE/CHAMPVA IN DEC07 (ED)";
label variable MCRJA07 "COVERED BY MEDICARE IN JAN07";
label variable MCRFE07 "COVERED BY MEDICARE IN FEB07";
label variable MCRMA07 "COVERED BY MEDICARE IN MAR07";
label variable MCRAP07 "COVERED BY MEDICARE IN APR07";
label variable MCRMY07 "COVERED BY MEDICARE IN MAY07";
label variable MCRJU07 "COVERED BY MEDICARE IN JUN07";
label variable MCRJL07 "COVERED BY MEDICARE IN JUL07";
label variable MCRAU07 "COVERED BY MEDICARE IN AUG07";
label variable MCRSE07 "COVERED BY MEDICARE IN SEP07";
label variable MCROC07 "COVERED BY MEDICARE IN OCT07";
label variable MCRNO07 "COVERED BY MEDICARE IN NOV07";
label variable MCRDE07 "COVERED BY MEDICARE IN DEC07";
label variable MCRJA07X "COVERED BY MEDICARE IN JAN07 (ED)";
label variable MCRFE07X "COVERED BY MEDICARE IN FEB07 (ED)";
label variable MCRMA07X "COVERED BY MEDICARE IN MAR07 (ED)";
label variable MCRAP07X "COVERED BY MEDICARE IN APR07 (ED)";
label variable MCRMY07X "COVERED BY MEDICARE IN MAY07 (ED)";
label variable MCRJU07X "COVERED BY MEDICARE IN JUN07 (ED)";
label variable MCRJL07X "COVERED BY MEDICARE IN JUL07 (ED)";
label variable MCRAU07X "COVERED BY MEDICARE IN AUG07 (ED)";
label variable MCRSE07X "COVERED BY MEDICARE IN SEP07 (ED)";
label variable MCROC07X "COVERED BY MEDICARE IN OCT07 (ED)";
label variable MCRNO07X "COVERED BY MEDICARE IN NOV07 (ED)";
label variable MCRDE07X "COVERED BY MEDICARE IN DEC07 (ED)";
label variable MCDJA07 "COV BY MEDICAID OR SCHIP IN JAN07";
label variable MCDFE07 "COV BY MEDICAID OR SCHIP IN FEB07";
label variable MCDMA07 "COV BY MEDICAID OR SCHIP IN MAR07";
label variable MCDAP07 "COV BY MEDICAID OR SCHIP IN APR07";
label variable MCDMY07 "COV BY MEDICAID OR SCHIP IN MAY07";
label variable MCDJU07 "COV BY MEDICAID OR SCHIP IN JUN07";
label variable MCDJL07 "COV BY MEDICAID OR SCHIP IN JUL07";
label variable MCDAU07 "COV BY MEDICAID OR SCHIP IN AUG07";
label variable MCDSE07 "COV BY MEDICAID OR SCHIP IN SEP07";
label variable MCDOC07 "COV BY MEDICAID OR SCHIP IN OCT07";
label variable MCDNO07 "COV BY MEDICAID OR SCHIP IN NOV07";
label variable MCDDE07 "COV BY MEDICAID OR SCHIP IN DEC07";
label variable MCDJA07X "COV BY MEDICAID OR SCHIP IN JAN07 (ED)";
label variable MCDFE07X "COV BY MEDICAID OR SCHIP IN FEB07 (ED)";
label variable MCDMA07X "COV BY MEDICAID OR SCHIP IN MAR07 (ED)";
label variable MCDAP07X "COV BY MEDICAID OR SCHIP IN APR07 (ED)";
label variable MCDMY07X "COV BY MEDICAID OR SCHIP IN MAY07 (ED)";
label variable MCDJU07X "COV BY MEDICAID OR SCHIP IN JUN07 (ED)";
label variable MCDJL07X "COV BY MEDICAID OR SCHIP IN JUL07 (ED)";
label variable MCDAU07X "COV BY MEDICAID OR SCHIP IN AUG07 (ED)";
label variable MCDSE07X "COV BY MEDICAID OR SCHIP IN SEP07 (ED)";
label variable MCDOC07X "COV BY MEDICAID OR SCHIP IN OCT07 (ED)";
label variable MCDNO07X "COV BY MEDICAID OR SCHIP IN NOV07 (ED)";
label variable MCDDE07X "COV BY MEDICAID OR SCHIP IN DEC07 (ED)";
label variable OPAJA07 "COV BY OTHER PUBLIC A INS IN JAN07";
label variable OPAFE07 "COV BY OTHER PUBLIC A INS IN FEB07";
label variable OPAMA07 "COV BY OTHER PUBLIC A INS IN MAR07";
label variable OPAAP07 "COV BY OTHER PUBLIC A INS IN APR07";
label variable OPAMY07 "COV BY OTHER PUBLIC A INS IN MAY07";
label variable OPAJU07 "COV BY OTHER PUBLIC A INS IN JUN07";
label variable OPAJL07 "COV BY OTHER PUBLIC A INS IN JUL07";
label variable OPAAU07 "COV BY OTHER PUBLIC A INS IN AUG07";
label variable OPASE07 "COV BY OTHER PUBLIC A INS IN SEP07";
label variable OPAOC07 "COV BY OTHER PUBLIC A INS IN OCT07";
label variable OPANO07 "COV BY OTHER PUBLIC A INS IN NOV07";
label variable OPADE07 "COV BY OTHER PUBLIC A INS IN DEC07";
label variable OPBJA07 "COV BY OTHER PUBLIC B INS IN JAN07";
label variable OPBFE07 "COV BY OTHER PUBLIC B INS IN FEB07";
label variable OPBMA07 "COV BY OTHER PUBLIC B INS IN MAR07";
label variable OPBAP07 "COV BY OTHER PUBLIC B INS IN APR07";
label variable OPBMY07 "COV BY OTHER PUBLIC B INS IN MAY07";
label variable OPBJU07 "COV BY OTHER PUBLIC B INS IN JUN07";
label variable OPBJL07 "COV BY OTHER PUBLIC B INS IN JUL07";
label variable OPBAU07 "COV BY OTHER PUBLIC B INS IN AUG07";
label variable OPBSE07 "COV BY OTHER PUBLIC B INS IN SEP07";
label variable OPBOC07 "COV BY OTHER PUBLIC B INS IN OCT07";
label variable OPBNO07 "COV BY OTHER PUBLIC B INS IN NOV07";
label variable OPBDE07 "COV BY OTHER PUBLIC B INS IN DEC07";
label variable STAJA07 "COVERED BY OTHER STATE PROG IN JAN07";
label variable STAFE07 "COVERED BY OTHER STATE PROG IN FEB07";
label variable STAMA07 "COVERED BY OTHER STATE PROG IN MAR07";
label variable STAAP07 "COVERED BY OTHER STATE PROG IN APR07";
label variable STAMY07 "COVERED BY OTHER STATE PROG IN MAY07";
label variable STAJU07 "COVERED BY OTHER STATE PROG IN JUN07";
label variable STAJL07 "COVERED BY OTHER STATE PROG IN JUL07";
label variable STAAU07 "COVERED BY OTHER STATE PROG IN AUG07";
label variable STASE07 "COVERED BY OTHER STATE PROG IN SEP07";
label variable STAOC07 "COVERED BY OTHER STATE PROG IN OCT07";
label variable STANO07 "COVERED BY OTHER STATE PROG IN NOV07";
label variable STADE07 "COVERED BY OTHER STATE PROG IN DEC07";
label variable PUBJA07X "COVR BY ANY PUBLIC INS IN JAN07 (ED)";
label variable PUBFE07X "COVR BY ANY PUBLIC INS IN FEB07 (ED)";
label variable PUBMA07X "COVR BY ANY PUBLIC INS IN MAR07(ED)";
label variable PUBAP07X "COVR BY ANY PUBLIC INS IN APR07 (ED)";
label variable PUBMY07X "COVR BY ANY PUBLIC INS IN MAY07 (ED)";
label variable PUBJU07X "COVR BY ANY PUBLIC INS IN JUN07 (ED)";
label variable PUBJL07X "COVR BY ANY PUBLIC INS IN JUL07 (ED)";
label variable PUBAU07X "COVR BY ANY PUBLIC INS IN AUG07 (ED)";
label variable PUBSE07X "COVR BY ANY PUBLIC INS IN SEP07 (ED)";
label variable PUBOC07X "COVR BY ANY PUBLIC INS IN OCT07 (ED)";
label variable PUBNO07X "COVR BY ANY PUBLIC INS IN NOV07 (ED)";
label variable PUBDE07X "COVR BY ANY PUBLIC INS IN DEC07 (ED)";
label variable PEGJA07 "COVERED BY EMPL UNION INS IN JAN07";
label variable PEGFE07 "COVERED BY EMPL UNION INS IN FEB07";
label variable PEGMA07 "COVERED BY EMPL UNION INS IN MAR07";
label variable PEGAP07 "COVERED BY EMPL UNION INS IN APR07";
label variable PEGMY07 "COVERED BY EMPL UNION INS IN MAY07";
label variable PEGJU07 "COVERED BY EMPL UNION INS IN JUN07";
label variable PEGJL07 "COVERED BY EMPL UNION INS IN JUL07";
label variable PEGAU07 "COVERED BY EMPL UNION INS IN AUG07";
label variable PEGSE07 "COVERED BY EMPL UNION INS IN SEP07";
label variable PEGOC07 "COVERED BY EMPL UNION INS IN OCT07";
label variable PEGNO07 "COVERED BY EMPL UNION INS IN NOV07";
label variable PEGDE07 "COVERED BY EMPL UNION INS IN DEC07";
label variable PDKJA07 "COVR BY PRIV INS (SOURCE UNKNWN) JAN07";
label variable PDKFE07 "COVR BY PRIV INS (SOURCE UNKNWN) FEB07";
label variable PDKMA07 "COVR BY PRIV INS (SOURCE UNKNWN) MAR07";
label variable PDKAP07 "COVR BY PRIV INS (SOURCE UNKNWN) APR07";
label variable PDKMY07 "COVR BY PRIV INS (SOURCE UNKNWN) MAY07";
label variable PDKJU07 "COVR BY PRIV INS (SOURCE UNKNWN) JUN07";
label variable PDKJL07 "COVR BY PRIV INS (SOURCE UNKNWN) JUL07";
label variable PDKAU07 "COVR BY PRIV INS (SOURCE UNKNWN) AUG07";
label variable PDKSE07 "COVR BY PRIV INS (SOURCE UNKNWN) SEP07";
label variable PDKOC07 "COVR BY PRIV INS (SOURCE UNKNWN) OCT07";
label variable PDKNO07 "COVR BY PRIV INS (SOURCE UNKNWN) NOV07";
label variable PDKDE07 "COVR BY PRIV INS (SOURCE UNKNWN) DEC07";
label variable PNGJA07 "COVERED BY NONGROUP INS IN JAN07";
label variable PNGFE07 "COVERED BY NONGROUP INS IN FEB07";
label variable PNGMA07 "COVERED BY NONGROUP INS IN MAR07";
label variable PNGAP07 "COVERED BY NONGROUP INS IN APR07";
label variable PNGMY07 "COVERED BY NONGROUP INS IN MAY07";
label variable PNGJU07 "COVERED BY NONGROUP INS IN JUN07";
label variable PNGJL07 "COVERED BY NONGROUP INS IN JUL07";
label variable PNGAU07 "COVERED BY NONGROUP INS IN AUG07";
label variable PNGSE07 "COVERED BY NONGROUP INS IN SEP07";
label variable PNGOC07 "COVERED BY NONGROUP INS IN OCT07";
label variable PNGNO07 "COVERED BY NONGROUP INS IN NOV07";
label variable PNGDE07 "COVERED BY NONGROUP INS IN DEC07";
label variable POGJA07 "COVERED BY OTHER GROUP INS IN JAN07";
label variable POGFE07 "COVERED BY OTHER GROUP INS IN FEB07";
label variable POGMA07 "COVERED BY OTHER GROUP INS IN MAR07";
label variable POGAP07 "COVERED BY OTHER GROUP INS IN APR07";
label variable POGMY07 "COVERED BY OTHER GROUP INS IN MAY07";
label variable POGJU07 "COVERED BY OTHER GROUP INS IN JUN07";
label variable POGJL07 "COVERED BY OTHER GROUP INS IN JUL07";
label variable POGAU07 "COVERED BY OTHER GROUP INS IN AUG07";
label variable POGSE07 "COVERED BY OTHER GROUP INS IN SEP07";
label variable POGOC07 "COVERED BY OTHER GROUP INS IN OCT07";
label variable POGNO07 "COVERED BY OTHER GROUP INS IN NOV07";
label variable POGDE07 "COVERED BY OTHER GROUP INS IN DEC07";
label variable PRSJA07 "COVERED BY SELF-EMP-1 INS IN JAN07";
label variable PRSFE07 "COVERED BY SELF-EMP-1 INS IN FEB07";
label variable PRSMA07 "COVERED BY SELF-EMP-1 INS IN MAR07";
label variable PRSAP07 "COVERED BY SELF-EMP-1 INS IN APR07";
label variable PRSMY07 "COVERED BY SELF-EMP-1 INS IN MAY07";
label variable PRSJU07 "COVERED BY SELF-EMP-1 INS IN JUN07";
label variable PRSJL07 "COVERED BY SELF-EMP-1 INS IN JUL07";
label variable PRSAU07 "COVERED BY SELF-EMP-1 INS IN AUG07";
label variable PRSSE07 "COVERED BY SELF-EMP-1 INS IN SEP07";
label variable PRSOC07 "COVERED BY SELF-EMP-1 INS IN OCT07";
label variable PRSNO07 "COVERED BY SELF-EMP-1 INS IN NOV07";
label variable PRSDE07 "COVERED BY SELF-EMP-1 INS IN DEC07";
label variable POUJA07 "COVERED BY HOLDER OUTSIDE OF RU IN JAN07";
label variable POUFE07 "COVERED BY HOLDER OUTSIDE OF RU IN FEB07";
label variable POUMA07 "COVERED BY HOLDER OUTSIDE OF RU IN MAR07";
label variable POUAP07 "COVERED BY HOLDER OUTSIDE OF RU IN APR07";
label variable POUMY07 "COVERED BY HOLDER OUTSIDE OF RU IN MAY07";
label variable POUJU07 "COVERED BY HOLDER OUTSIDE OF RU IN JUN07";
label variable POUJL07 "COVERED BY HOLDER OUTSIDE OF RU IN JUL07";
label variable POUAU07 "COVERED BY HOLDER OUTSIDE OF RU IN AUG07";
label variable POUSE07 "COVERED BY HOLDER OUTSIDE OF RU IN SEP07";
label variable POUOC07 "COVERED BY HOLDER OUTSIDE OF RU IN OCT07";
label variable POUNO07 "COVERED BY HOLDER OUTSIDE OF RU IN NOV07";
label variable POUDE07 "COVERED BY HOLDER OUTSIDE OF RU IN DEC07";
label variable PRIJA07 "COVERED BY PRIVATE INS IN JAN07";
label variable PRIFE07 "COVERED BY PRIVATE INS IN FEB07";
label variable PRIMA07 "COVERED BY PRIVATE INS IN MAR07";
label variable PRIAP07 "COVERED BY PRIVATE INS IN APR07";
label variable PRIMY07 "COVERED BY PRIVATE INS IN MAY07";
label variable PRIJU07 "COVERED BY PRIVATE INS IN JUN07";
label variable PRIJL07 "COVERED BY PRIVATE INS IN JUL07";
label variable PRIAU07 "COVERED BY PRIVATE INS IN AUG07";
label variable PRISE07 "COVERED BY PRIVATE INS IN SEP07";
label variable PRIOC07 "COVERED BY PRIVATE INS IN OCT07";
label variable PRINO07 "COVERED BY PRIVATE INS IN NOV07";
label variable PRIDE07 "COVERED BY PRIVATE INS IN DEC07";
label variable HPEJA07 "HOLDER OF EMPL UNION INS IN JAN07";
label variable HPEFE07 "HOLDER OF EMPL UNION INS IN FEB07";
label variable HPEMA07 "HOLDER OF EMPL UNION INS IN MAR07";
label variable HPEAP07 "HOLDER OF EMPL UNION INS IN APR07";
label variable HPEMY07 "HOLDER OF EMPL UNION INS IN MAY07";
label variable HPEJU07 "HOLDER OF EMPL UNION INS IN JUN07";
label variable HPEJL07 "HOLDER OF EMPL UNION INS IN JUL07";
label variable HPEAU07 "HOLDER OF EMPL UNION INS IN AUG07";
label variable HPESE07 "HOLDER OF EMPL UNION INS IN SEP07";
label variable HPEOC07 "HOLDER OF EMPL UNION INS IN OCT07";
label variable HPENO07 "HOLDER OF EMPL UNION INS IN NOV07";
label variable HPEDE07 "HOLDER OF EMPL UNION INS IN DEC07";
label variable HPDJA07 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN07";
label variable HPDFE07 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB07";
label variable HPDMA07 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR07";
label variable HPDAP07 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR07";
label variable HPDMY07 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY07";
label variable HPDJU07 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN07";
label variable HPDJL07 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL07";
label variable HPDAU07 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG07";
label variable HPDSE07 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP07";
label variable HPDOC07 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT07";
label variable HPDNO07 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV07";
label variable HPDDE07 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC07";
label variable HPNJA07 "HOLDER OF NONGROUP INS IN JAN07";
label variable HPNFE07 "HOLDER OF NONGROUP INS IN FEB07";
label variable HPNMA07 "HOLDER OF NONGROUP INS IN MAR07";
label variable HPNAP07 "HOLDER OF NONGROUP INS IN APR07";
label variable HPNMY07 "HOLDER OF NONGROUP INS IN MAY07";
label variable HPNJU07 "HOLDER OF NONGROUP INS IN JUN07";
label variable HPNJL07 "HOLDER OF NONGROUP INS IN JUL07";
label variable HPNAU07 "HOLDER OF NONGROUP INS IN AUG07";
label variable HPNSE07 "HOLDER OF NONGROUP INS IN SEP07";
label variable HPNOC07 "HOLDER OF NONGROUP INS IN OCT07";
label variable HPNNO07 "HOLDER OF NONGROUP INS IN NOV07";
label variable HPNDE07 "HOLDER OF NONGROUP INS IN DEC07";
label variable HPOJA07 "HOLDER OF OTHER GROUP INS IN JAN07";
label variable HPOFE07 "HOLDER OF OTHER GROUP INS IN FEB07";
label variable HPOMA07 "HOLDER OF OTHER GROUP INS IN MAR07";
label variable HPOAP07 "HOLDER OF OTHER GROUP INS IN APR07";
label variable HPOMY07 "HOLDER OF OTHER GROUP INS IN MAY07";
label variable HPOJU07 "HOLDER OF OTHER GROUP INS IN JUN07";
label variable HPOJL07 "HOLDER OF OTHER GROUP INS IN JUL07";
label variable HPOAU07 "HOLDER OF OTHER GROUP INS IN AUG07";
label variable HPOSE07 "HOLDER OF OTHER GROUP INS IN SEP07";
label variable HPOOC07 "HOLDER OF OTHER GROUP INS IN OCT07";
label variable HPONO07 "HOLDER OF OTHER GROUP INS IN NOV07";
label variable HPODE07 "HOLDER OF OTHER GROUP INS IN DEC07";
label variable HPSJA07 "HOLDER OF SELF-EMP-1 INS IN JAN07";
label variable HPSFE07 "HOLDER OF SELF-EMP-1 INS IN FEB07";
label variable HPSMA07 "HOLDER OF SELF-EMP-1 INS IN MAR07";
label variable HPSAP07 "HOLDER OF SELF-EMP-1 INS IN APR07";
label variable HPSMY07 "HOLDER OF SELF-EMP-1 INS IN MAY07";
label variable HPSJU07 "HOLDER OF SELF-EMP-1 INS IN JUN07";
label variable HPSJL07 "HOLDER OF SELF-EMP-1 INS IN JUL07";
label variable HPSAU07 "HOLDER OF SELF-EMP-1 INS IN AUG07";
label variable HPSSE07 "HOLDER OF SELF-EMP-1 INS IN SEP07";
label variable HPSOC07 "HOLDER OF SELF-EMP-1 INS IN OCT07";
label variable HPSNO07 "HOLDER OF SELF-EMP-1 INS IN NOV07";
label variable HPSDE07 "HOLDER OF SELF-EMP-1 INS IN DEC07";
label variable HPRJA07 "HOLDER OF PRIVATE INSURANCE IN JAN07";
label variable HPRFE07 "HOLDER OF PRIVATE INSURANCE IN FEB07";
label variable HPRMA07 "HOLDER OF PRIVATE INSURANCE IN MAR07";
label variable HPRAP07 "HOLDER OF PRIVATE INSURANCE IN APR07";
label variable HPRMY07 "HOLDER OF PRIVATE INSURANCE IN MAY07";
label variable HPRJU07 "HOLDER OF PRIVATE INSURANCE IN JUN07";
label variable HPRJL07 "HOLDER OF PRIVATE INSURANCE IN JUL07";
label variable HPRAU07 "HOLDER OF PRIVATE INSURANCE IN AUG07";
label variable HPRSE07 "HOLDER OF PRIVATE INSURANCE IN SEP07";
label variable HPROC07 "HOLDER OF PRIVATE INSURANCE IN OCT07";
label variable HPRNO07 "HOLDER OF PRIVATE INSURANCE IN NOV07";
label variable HPRDE07 "HOLDER OF PRIVATE INSURANCE IN DEC07";
label variable INSJA07X "COVR BY HOSP/MED INS IN JAN07 (ED)";
label variable INSFE07X "COVR BY HOSP/MED INS IN FEB07 (ED)";
label variable INSMA07X "COVR BY HOSP/MED INS IN MAR07 (ED)";
label variable INSAP07X "COVR BY HOSP/MED INS IN APR07 (ED)";
label variable INSMY07X "COVR BY HOSP/MED INS IN MAY07 (ED)";
label variable INSJU07X "COVR BY HOSP/MED INS IN JUN07 (ED)";
label variable INSJL07X "COVR BY HOSP/MED INS IN JUL07 (ED)";
label variable INSAU07X "COVR BY HOSP/MED INS IN AUG07 (ED)";
label variable INSSE07X "COVR BY HOSP/MED INS IN SEP07 (ED)";
label variable INSOC07X "COVR BY HOSP/MED INS IN OCT07 (ED)";
label variable INSNO07X "COVR BY HOSP/MED INS IN NOV07 (ED)";
label variable INSDE07X "COVR BY HOSP/MED INS IN DEC07 (ED)";
label variable PRVEV07 "EVER HAVE PRIVATE INSURANCE DURING 07";
label variable TRIEV07 "EVER HAVE TRICARE/CHAMPVA DURING 07";
label variable MCREV07 "EVER HAVE MEDICARE DURING 07 (ED)";
label variable MCDEV07 "EVER HAVE MEDICAID/SCHIP DURING 07 (ED)";
label variable OPAEV07 "EVER HAVE OTHER PUBLIC A INS DURING 07";
label variable OPBEV07 "EVER HAVE OTHER PUBLIC B INS DURING 07";
label variable UNINS07 "UNINSURED ALL OF 07";
label variable INSCOV07 "HEALTH INSURANCE COVERAGE INDICATOR 07";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST07X "COVERED BY TRICARE STANDARD - 12/31/07";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR07X "COVERED BY TRICARE PRIME - 12/31/07";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX07X "COVERED BY TRICARE EXTRA - 12/31/07";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI07X "COVERED BY TRICARE FOR LIFE - 12/31/07";
label variable TRICH31X "COVERED BY TRICARE CHAMPVA - R3/1";
label variable TRICH42X "COVERED BY TRICARE CHAMPVA - R4/2";
label variable TRICH07X "COVERED BY TRICARE CHAMPVA - 12/31/07";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD07 "COV BY MEDICARE PMED BENEFIT - 12/31/07";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD07X "COV BY MCARE PMED BENEFIT-12/31/07 (ED)";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO07 "COV BY MEDICARE MANAGED CARE - 12/31/07";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO07 "COVRED BY MEDICAID OR SCHIP HMO-12/31/07";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC07 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/07";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO07 "COVERED BY PRIVATE HMO - 12/31/07";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC07 "COVERED BY PRIV GATEKEEPER PLAN-12/31/07";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL07 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/07";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP07 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/07";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP07 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/07";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP07 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/07";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 12 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 12 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 12 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 12 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 12 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 12 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 12 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 12 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 12 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 12 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 12 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 12 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 12 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 12 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 12 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 12 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 12 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 12 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 12 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 12 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 12 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 12 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 12 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR07X "COV BY TRICR/CHAMV - 12/31/07 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE/CHAMPVA - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE/CHAMPVA - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE/CHAMPVA - R5/3";
label variable TRIAT07X "ANY TIME COV TRICARE/CHAMPVA - 12/31/07";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID07 "COV BY MEDICAID OR SCHIP - 12/31/07";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID07X "COV BY MEDICAID OR SCHIP - 12/31/07 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE07 "COV BY MEDICARE - 12/31/07";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE07X "COV BY MEDICARE - 12/31/07 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT07X "ANY TIME COV MEDICAID OR SCHIP-12/31/07";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT07 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/07";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT07 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/07";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA07 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/07";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB07 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/07";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK07 "COV BY PRIV INS (DK PLAN) - 12/31/07";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU07 "COV BY EMPL/UNION GRP INS - 12/31/07";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING07 "COV BY NON-GROUP INS - 12/31/07";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG07 "COV BY OTHER GROUP INS - 12/31/07";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS07 "COV BY SELF-EMP-1 INS - 12/31/07";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV07 "COV BY PRIV HLTH INS - 12/31/07";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT07 "ANY TIME COV PRIVATE INS - 12/31/07";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT07 "COV BY SOMEONE OUT OF RU - 12/31/07";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB07X "COV BY PUBLIC INS - 12/31/07 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT07X "ANY TIME COV BY PUBLIC - 12/31/07";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS07X "INSURED - 12/31/07 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT07X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/07";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR07 "COV BY STATE-SPEC PROG - 12/31/07";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT07 "ANY TIME COV BY STATE INS - 12/31/07";
label variable EVRUNINS "EVER UNINSURED IN 07 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 07 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable DNTINS31 "DENTAL INS - RD 3/1 IN 07";
label variable DNTINS07 "DENTAL INS - R5/R3 UNTIL 12/31/07";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 07";
label variable PMDINS07 "PMED INS - R5/R3 UNTIL 12/31/07";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable PMEDOP31 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R3/1";
label variable PMEDOP42 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R4/2";
label variable PMEDOP53 "OUT-OF-POCKET PAYMENT FOR LAST PMED-R5/3";
label variable GDCPBM42 "MCAID/SCHIP/O PUB: PRB GET PERS DOC-R4/2";
label variable APRTRM42 "MCAID/SCHIP/O PUB: NEED APPRV 4 TRT-R4/2";
label variable APRDLM42 "MCAID/SCHIP/O PUB: DLY WAIT 4 APPRV-R4/2";
label variable LKINFM42 "MCAID/SCHIP/O PUB: LOOK 4 PLAN INFO-R4/2";
label variable PBINFM42 "MCAID/SCHIP/O PUB: PROB FINDNG INFO-R4/2";
label variable CSTSVM42 "MCAID/SCHIP/O PUB: CALL CUSTMR SERV-R4/2";
label variable PBSVCM42 "MCAID/SCHIP/O PUB: PRB W CUSRVC HLP-R4/2";
label variable PPRWKM42 "MCAID/SCHIP/O PUB: COMP PLAN PPRWRK-R4/2";
label variable PBPWKM42 "MCAID/SCHIP/O PUB: PRB W PLN PPRWRK-R4/2";
label variable RTPLNM42 "MCAID/SCHIP/O PUB: RATE EXP W PLAN-R4/2";
label variable GDCPBT42 "TRICR/CHAMV: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICR/CHAMV: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICR/CHAMV: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICR/CHAMV: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICR/CHAMV: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICR/CHAMV: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICR/CHAMV: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKT42 "TRICR/CHAMV:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICR/CHAMV: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICR/CHAMV: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH07 "TOTAL HEALTH CARE CHARGES 07, EXCL RX";
label variable TOTEXP07 "TOTAL HEALTH CARE EXP 07";
label variable TOTSLF07 "TOTAL AMT PAID BY SELF/FAMILY 07";
label variable TOTMCR07 "TOTAL AMT PAID BY MEDICARE 07";
label variable TOTMCD07 "TOTAL AMT PAID BY MEDICAID 07";
label variable TOTPRV07 "TOTAL AMT PAID BY PRIVATE INS 07";
label variable TOTVA07 "TOTAL AMT PAID BY VA 07";
label variable TOTTRI07 "TOTAL AMT PAID BY TRICARE 07";
label variable TOTOFD07 "TOTAL AMT PAID BY OTHER FEDERAL 07";
label variable TOTSTL07 "TOTAL AMT PAID BY OTH ST/LOCAL 07";
label variable TOTWCP07 "TOTAL AMT PAID BY WORKERS COMP 07";
label variable TOTOPR07 "TOTAL AMT PAID BY OTHER PRIVATE 07";
label variable TOTOPU07 "TOTAL AMT PAID BY OTHER PUBLIC 07";
label variable TOTOSR07 "TOTAL AMT PAID BY OTHER SOURCES 07";
label variable OBTOTV07 "# OFFICE-BASED PROVIDER VISITS 07";
label variable OBVTCH07 "OFFICE-BASED PROVIDER VISIT CHARGES 07";
label variable OBVEXP07 "TOTAL OFFICE-BASED EXP 07";
label variable OBVSLF07 "ALL OFFICE VISITS -SELF/FAMILY AMT 07";
label variable OBVMCR07 "ALL OFFICE VISITS -MEDICARE AMT 07";
label variable OBVMCD07 "ALL OFFICE VISITS -MEDICAID AMT 07";
label variable OBVPRV07 "ALL OFFICE VISITS -PRIVATE INS AMT 07";
label variable OBVVA07 "ALL OFFICE VISITS-VA AMT 07";
label variable OBVTRI07 "ALL OFFICE VISITS-TRICARE AMT 07";
label variable OBVOFD07 "ALL OFFICE VISITS-OTHER FEDERAL AMT 07";
label variable OBVSTL07 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 07";
label variable OBVWCP07 "ALL OFFICE VISITS -WORKERS COMP AMT 07";
label variable OBVOPR07 "ALL OFFICE VISITS - OTH PRIVATE AMT 07";
label variable OBVOPU07 "ALL OFFICE VISITS - OTH PUBLIC AMT 07";
label variable OBVOSR07 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 07";
label variable OBDRV07 "# OFFICE-BASED PHYSICIAN VISITS 07";
label variable OBDTCH07 "OFFICE-BASED PHYSICIAN VISIT CHARGES 07";
label variable OBDEXP07 "TOTAL OFF-BASED DR EXP 07";
label variable OBDSLF07 "DR OFFICE VISITS -SELF/FAMILY AMT 07";
label variable OBDMCR07 "DR OFFICE VISITS -MEDICARE AMT 07";
label variable OBDMCD07 "DR OFFICE VISITS -MEDICAID AMT 07";
label variable OBDPRV07 "DR OFFICE VISITS -PRIVATE INS AMT 07";
label variable OBDVA07 "DR OFFICE VISITS -VA AMT 07";
label variable OBDTRI07 "DR OFFICE VISITS -TRICARE AMT 07";
label variable OBDOFD07 "DR OFFICE VISITS -OTHER FEDERAL AMT 07";
label variable OBDSTL07 "DR OFFICE VISITS -OTH ST/LOCAL AMT 07";
label variable OBDWCP07 "DR OFFICE VISITS -WORKERS COMP AMT 07";
label variable OBDOPR07 "DR OFFICE VISITS - OTH PRIVATE AMT 07";
label variable OBDOPU07 "DR OFFICE VISITS - OTH PUBLIC AMT 07";
label variable OBDOSR07 "DR OFF VSTS - OTH UNCLASS SRCE AMT 07";
label variable OBOTHV07 "# OFFICE-BASED NON-PHYSICAN VISITS 07";
label variable OBOTCH07 "OFFICE-BASED NON-DR VISIT CHARGES 07";
label variable OBOEXP07 "TOTAL OFF-BASED NON-DR EXP 07";
label variable OBOSLF07 "NON-DR OFF VISTS -SELF/FAMILY AMT 07";
label variable OBOMCR07 "NON-DR OFF VISTS -MEDICARE AMT 07";
label variable OBOMCD07 "NON-DR OFF VISTS -MEDICAID AMT 07";
label variable OBOPRV07 "NON-DR OFF VISTS -PRIVATE INS AMT 07";
label variable OBOVA07 "NON-DR OFF VISTS -VA AMT 07";
label variable OBOTRI07 "NON-DR OFF VISTS -TRICARE AMT 07";
label variable OBOOFD07 "NON-DR OFF VISTS -OTHER FEDERAL AMT 07";
label variable OBOSTL07 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 07";
label variable OBOWCP07 "NON-DR OFF VISTS -WORKERS COMP AMT 07";
label variable OBOOPR07 "NON-DR OFF VISTS - OTH PRIVATE AMT 07";
label variable OBOOPU07 "NON-DR OFF VISTS - OTH PUBLIC AMT 07";
label variable OBOOSR07 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 07";
label variable OBCHIR07 "# OFFICE-BASED CHIROPRACTOR VISITS 07";
label variable OBCTCH07 "OFFICE-BASED CHIRO VISIT CHARGES 07";
label variable OBCEXP07 "TOTAL OFF-BASED CHIRO EXP 07";
label variable OBCSLF07 "CHIRO OFF VISITS -SELF/FAMILY AMT 07";
label variable OBCMCR07 "CHIRO OFF VISITS -MEDICARE AMT 07";
label variable OBCMCD07 "CHIRO OFF VISITS -MEDICAID AMT 07";
label variable OBCPRV07 "CHIRO OFF VISITS -PRIVATE INS AMT 07";
label variable OBCVA07 "CHIRO OFF VISITS -VA AMT 07";
label variable OBCTRI07 "CHIRO OFF VISITS -TRICARE AMT 07";
label variable OBCOFD07 "CHIRO OFF VISITS -OTHER FEDERAL AMT 07";
label variable OBCSTL07 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 07";
label variable OBCWCP07 "CHIRO OFF VISITS -WORKERS COMP AMT 07";
label variable OBCOPR07 "CHIRO OFF VISTS - OTHR PRIVATE AMT 07";
label variable OBCOPU07 "CHIRO OFF VISTS - OTHR PUBLIC AMT 07";
label variable OBCOSR07 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 07";
label variable OBNURS07 "# OFF-BASED NURSE/PRACTITIONER VISITS 07";
label variable OBNTCH07 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 07";
label variable OBNEXP07 "TOTAL OFF-BASED NURSE/PRAC 07";
label variable OBNSLF07 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 07";
label variable OBNMCR07 "NURSE/PRAC OFF VISITS -MEDICARE AMT 07";
label variable OBNMCD07 "NURSE/PRAC OFF VSTS -MEDICAID AMT 07";
label variable OBNPRV07 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 07";
label variable OBNVA07 "NURSE/PRAC OFF VSTS -VA AMT 07";
label variable OBNTRI07 "NURSE/PRAC OFF VSTS -TRICARE AMT 07";
label variable OBNOFD07 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 07";
label variable OBNSTL07 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 07";
label variable OBNWCP07 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 07";
label variable OBNOPR07 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 07";
label variable OBNOPU07 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 07";
label variable OBNOSR07 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 07";
label variable OBOPTO07 "# OFF-BASED OPTOMETRIST VISITS 07";
label variable OBETCH07 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 07";
label variable OBEEXP07 "TOTAL OFF-BASED OPOTMETRIST EXP 07";
label variable OBESLF07 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 07";
label variable OBEMCR07 "OPTOMETRIST OFF VSTS -MEDICARE AMT 07";
label variable OBEMCD07 "OPTOMETRIST OFF VSTS -MEDICAID AMT 07";
label variable OBEPRV07 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 07";
label variable OBEVA07 "OPTOMETRIST OFF VSTS -VA AMT 07";
label variable OBETRI07 "OPTOMETRIST OFF VSTS -TRICARE AMT 07";
label variable OBEOFD07 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 07";
label variable OBESTL07 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 07";
label variable OBEWCP07 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 07";
label variable OBEOPR07 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 07";
label variable OBEOPU07 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 07";
label variable OBEOSR07 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 07";
label variable OBASST07 "# OFF-BASED PHYSICIAN ASSIST VISITS 07";
label variable OBATCH07 "OFFICE-BASED PHYS ASST VISIT CHARGES 07";
label variable OBAEXP07 "TOTAL OFF-BASED PHYS ASS T EXP 07";
label variable OBASLF07 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 07";
label variable OBAMCR07 "PHYS ASS T OFF VSTS -MEDICARE AMT 07";
label variable OBAMCD07 "PHYS ASS T OFF VSTS -MEDICAID AMT 07";
label variable OBAPRV07 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 07";
label variable OBAVA07 "PHYS ASS T OFF VSTS -VA AMT 07";
label variable OBATRI07 "PHYS ASS T OFF VSTS -TRICARE AMT 07";
label variable OBAOFD07 "PHYS ASS T OFF VSTS -OTHER FED AMT 07";
label variable OBASTL07 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 07";
label variable OBAWCP07 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 07";
label variable OBAOPR07 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 07";
label variable OBAOPU07 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 07";
label variable OBAOSR07 "P A OFF VSTS - OTH UNCLASS SRCE AMT 07";
label variable OBTHER07 "# OFF-BASED PT/OT VISITS 07";
label variable OBTTCH07 "OFFICE-BASED PT/OC VISIT CHARGES 07";
label variable OBTEXP07 "TOT OFF-BASED PT EXP 07";
label variable OBTSLF07 "PT/OT OFF VISITS -SELF/FAMILY AMT 07";
label variable OBTMCR07 "PT/OT OFF VISITS -MEDICARE AMT 07";
label variable OBTMCD07 "PT/OT OFF VISITS -MEDICAID AMT 07";
label variable OBTPRV07 "PT/OT OFF VISITS -PRIVATE INS AMT 07";
label variable OBTVA07 "PT/OT OFF VISITS -VA AMT 07";
label variable OBTTRI07 "PT/OT OFF VISITS -TRICARE AMT 07";
label variable OBTOFD07 "PT/OT OFF VISITS -OTHER FED AMT 07";
label variable OBTSTL07 "PT/OT OFF VISITS -OTH ST/LOCL AMT 07";
label variable OBTWCP07 "PT/OT OFF VISITS -WORKERS COMP AMT 07";
label variable OBTOPR07 "PT/OT OFF VISITS - OTH PRIVATE AMT 07";
label variable OBTOPU07 "PT/OT OFF VISITS - OTH PUBLIC AMT 07";
label variable OBTOSR07 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 07";
label variable OPTOTV07 "# OUTPATIENT DEPT PROVIDER VISITS 07";
label variable OPTTCH07 "OPD FACILITY + DR VISIT CHARGES - 07";
label variable OPTEXP07 "TOTAL OUTPATIENT FAC + DR EXP 07";
label variable OPTSLF07 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 07";
label variable OPTMCR07 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 07";
label variable OPTMCD07 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 07";
label variable OPTPRV07 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 07";
label variable OPTVA07 "ALL OPD VSTS-VA AMT-(FAC+DR) 07";
label variable OPTTRI07 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 07";
label variable OPTOFD07 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 07";
label variable OPTSTL07 "ALL OPD VSTS-OTH ST/LOCAL AMT-(FAC+DR) 07";
label variable OPTWCP07 "ALL OPD VSTS-WORKERS COMP AMT-(FAC+DR) 07";
label variable OPTOPR07 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 07";
label variable OPTOPU07 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 07";
label variable OPTOSR07 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-(FAC+DR) 07";
label variable OPFTCH07 "OPD PROVIDER VISIT CHARGES - FAC 07";
label variable OPFEXP07 "TOTAL OUTPATIENT FACILITY EXP 07";
label variable OPFSLF07 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 07";
label variable OPFMCR07 "ALL OPD VISITS-MEDICARE AMT-FAC 07";
label variable OPFMCD07 "ALL OPD VISITS-MEDICAID AMT-FAC 07";
label variable OPFPRV07 "ALL OPD VISITS-PRIV INS AMT-FAC 07";
label variable OPFVA07 "ALL OPD VISITS-VA AMT-FAC 07";
label variable OPFTRI07 "ALL OPD VISITS-TRICARE AMT-FAC 07";
label variable OPFOFD07 "ALL OPD VISITS-OTHER FED AMT-FAC 07";
label variable OPFSTL07 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 07";
label variable OPFWCP07 "ALL OPD VISITS-WORKERS COMP AMT-FAC 07";
label variable OPFOPR07 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 07";
label variable OPFOPU07 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 07";
label variable OPFOSR07 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 07";
label variable OPDEXP07 "TOTAL OUTPATIENT PROVIDER EXP 07";
label variable OPDTCH07 "OPD PROVIDER VISIT CHARGES - DR 07";
label variable OPDSLF07 "ALL OPD VISITS-SELF/FAMILY AMT-DR 07";
label variable OPDMCR07 "ALL OPD VISITS-MEDICARE AMT -DR 07";
label variable OPDMCD07 "ALL OPD VISITS-MEDICAID AMT -DR 07";
label variable OPDPRV07 "ALL OPD VISITS-PRIV INS AMT-DR 07";
label variable OPDVA07 "ALL OPD VISITS-VA AMT-DR 07";
label variable OPDTRI07 "ALL OPD VISITS-TRICARE AMT-DR 07";
label variable OPDOFD07 "ALL OPD VISITS-OTHER FED AMT-DR 07";
label variable OPDSTL07 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 07";
label variable OPDWCP07 "ALL OPD VISITS-WORKERS COMP AMT-DR 07";
label variable OPDOPR07 "ALL OPD VISITS - OTH PRIVATE AMT-DR 07";
label variable OPDOPU07 "ALL OPD VISITS-OTH PUBLIC AMT-DR 07";
label variable OPDOSR07 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 07";
label variable OPDRV07 "# OUTPATIENT DEPT PHYSICIAN VISITS 07";
label variable OPVTCH07 "OPD PHYSICIAN VISIT CHARGES - FAC 07";
label variable OPVEXP07 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 07";
label variable OPVSLF07 "OPD DR VISITS-SELF/FAMILY AMT-FAC 07";
label variable OPVMCR07 "OPD DR VISITS-MEDICARE AMT-FAC 07";
label variable OPVMCD07 "OPD DR VISITS-MEDICAID AMT-FAC 07";
label variable OPVPRV07 "OPD DR VISITS-PRIV INS AMT-FAC 07";
label variable OPVVA07 "OPD DR VISITS-VA AMT-FAC 07";
label variable OPVTRI07 "OPD DR VISITS-TRICARE AMT-FAC 07";
label variable OPVOFD07 "OPD DR VISITS-OTHER FED AMT-FAC 07";
label variable OPVSTL07 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 07";
label variable OPVWCP07 "OPD DR VISITS-WORKERS COMP AMT-FAC 07";
label variable OPVOPR07 "OPD DR VISITS - OTH PRIVATE AMT-FAC 07";
label variable OPVOPU07 "OPD DR VISITS-OTH PUBLIC AMT-FAC 07";
label variable OPVOSR07 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 07";
label variable OPSEXP07 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 07";
label variable OPSTCH07 "OPD PHYSICIAN VISIT CHARGES - DR 07";
label variable OPSSLF07 "OPD DR VISITS-SELF/FAMILY AMT-DR 07";
label variable OPSMCR07 "OPD DR VISITS-MEDICARE AMT-DR 07";
label variable OPSMCD07 "OPD DR VISITS-MEDICAID AMT-DR 07";
label variable OPSPRV07 "OPD DR VISITS-PRIV INS AMT-DR 07";
label variable OPSVA07 "OPD DR VISITS-VA AMT-DR 07";
label variable OPSTRI07 "OPD DR VISITS-TRICARE AMT-DR 07";
label variable OPSOFD07 "OPD DR VISITS-OTHER FED AMT-DR 07";
label variable OPSSTL07 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 07";
label variable OPSWCP07 "OPD DR VISITS-WORKERS COMP AMT-DR 07";
label variable OPSOPR07 "OPD DR VISITS - OTH PRIVATE AMT-DR 07";
label variable OPSOPU07 "OPD DR VISITS-OTH PUBLIC AMT-DR 07";
label variable OPSOSR07 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 07";
label variable OPOTHV07 "# OUTPATIENT DEPT NON-DR VISITS 07";
label variable OPOTCH07 "OPD NON-PHYS VISIT CHARGES - FAC 07";
label variable OPOEXP07 "TOTAL OUTPATIENT NON-DR - FAC EXP 07";
label variable OPOSLF07 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 07";
label variable OPOMCR07 "OPD NON-DR VISITS-MEDICARE AMT-FAC 07";
label variable OPOMCD07 "OPD NON-DR VISITS-MEDICAID AMT-FAC 07";
label variable OPOPRV07 "OPD NON-DR VISITS-PRIV INS AMT-FAC 07";
label variable OPOVA07 "OPD NON-DR VISITS-VA AMT-FAC 07";
label variable OPOTRI07 "OPD NON-DR VISITS-TRICARE AMT-FAC 07";
label variable OPOOFD07 "OPD NON-DR VISITS-OTHER FED AMT-FAC 07";
label variable OPOSTL07 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 07";
label variable OPOWCP07 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 07";
label variable OPOOPR07 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 07";
label variable OPOOPU07 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 07";
label variable OPOOSR07 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 07";
label variable OPPEXP07 "TOTAL OUTPATIENT NON-DR - DR EXP 07";
label variable OPPTCH07 "OPD NON-PHYS VISIT CHARGES - DR 07";
label variable OPPSLF07 "OPD NON-DR VISITS-SELF/FAM AMT-DR 07";
label variable OPPMCR07 "OPD NON-DR VISITS-MEDICARE AMT-DR 07";
label variable OPPMCD07 "OPD NON-DR VISITS-MEDICAID AMT-DR 07";
label variable OPPPRV07 "OPD NON-DR VISITS-PRIV INS AMT-DR 07";
label variable OPPVA07 "OPD NON-DR VISITS-VA AMT-DR 07";
label variable OPPTRI07 "OPD NON-DR VISITS-TRICARE AMT-DR 07";
label variable OPPOFD07 "OPD NON-DR VISITS-OTHER FED AMT-DR 07";
label variable OPPSTL07 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 07";
label variable OPPWCP07 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 07";
label variable OPPOPR07 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 07";
label variable OPPOPU07 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 07";
label variable OPPOSR07 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 07";
label variable AMCHIR07 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2007";
label variable AMCTCH07 "CHIRO AMBULATORY VISIT CHARGES 07";
label variable AMCEXP07 "TOTL AMBULTRY (OB+OP) CHIRO EXP 07";
label variable AMCSLF07 "CHIRO AMB VISITS -SELF/FAMILY AMT 07";
label variable AMCMCR07 "CHIRO AMB VISITS -MEDICARE AMT 07";
label variable AMCMCD07 "CHIRO AMB VISITS -MEDICAID AMT 07";
label variable AMCPRV07 "CHIRO AMB VISITS -PRIVATE INS AMT 07";
label variable AMCVA07 "CHIRO AMB VISITS -VA AMT 07";
label variable AMCTRI07 "CHIRO AMB VISITS-TRICARE AMT 07";
label variable AMCOFD07 "CHIRO AMB VISITS -OTHER FEDERAL AMT 07";
label variable AMCSTL07 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 07";
label variable AMCWCP07 "CHIRO AMB VISITS-WORKERS COMP AMT 07";
label variable AMCOPR07 "CHIRO AMB VISITS - OTH PRIVATE AMT 07";
label variable AMCOPU07 "CHIRO AMB VISITS - OTH PUBLIC AMT 07";
label variable AMCOSR07 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 07";
label variable AMNURS07 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 07";
label variable AMNTCH07 "NRS/PRAC AMBULATORY VISIT CHARGES 07";
label variable AMNEXP07 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 07";
label variable AMNSLF07 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 07";
label variable AMNMCR07 "NRS/PRAC AMB VSTS -MEDICARE AMT 07";
label variable AMNMCD07 "NRS/PRAC AMB VSTS -MEDICAID AMT 07";
label variable AMNPRV07 "NRS/PRAC AMB VSTS -PRIV INS AMT 07";
label variable AMNVA07 "NRS/PRAC AMB VSTS-VA AMT 07";
label variable AMNTRI07 "NRS/PRAC AMB VSTS-TRICARE AMT 07";
label variable AMNOFD07 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 07";
label variable AMNSTL07 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 07";
label variable AMNWCP07 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 07";
label variable AMNOPR07 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 07";
label variable AMNOPU07 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 07";
label variable AMNOSR07 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 07";
label variable AMOPTO07 "# AMB OPTOMETRIST VSTS (OB+OP) 07";
label variable AMETCH07 "OPTOMETRIST AMBULATORY VISIT CHARGES 07";
label variable AMEEXP07 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 07";
label variable AMESLF07 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 07";
label variable AMEMCR07 "OPTMTRIST AMB VSTS -MEDICARE AMT 07";
label variable AMEMCD07 "OPTMTRIST AMB VSTS -MEDICAID AMT 07";
label variable AMEPRV07 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 07";
label variable AMEVA07 "OPTMTRIST AMB VSTS-VA AMT 07";
label variable AMETRI07 "OPTMTRIST AMB VSTS-TRICARE AMT 07";
label variable AMEOFD07 "OPTMTRIST AMB VSTS-OTHER FED AMT 07";
label variable AMESTL07 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 07";
label variable AMEWCP07 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 07";
label variable AMEOPR07 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 07";
label variable AMEOPU07 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 07";
label variable AMEOSR07 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 07";
label variable AMASST07 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2007";
label variable AMATCH07 "PHYS ASS T AMBULATORY VISIT CHARGES 07";
label variable AMAEXP07 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 07";
label variable AMASLF07 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 07";
label variable AMAMCR07 "PHYS ASS T AMB VSTS-MEDICARE AMT 07";
label variable AMAMCD07 "PHYS ASS T AMB VSTS-MEDICAID AMT 07";
label variable AMAPRV07 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 07";
label variable AMAVA07 "PHYS ASS T AMB VSTS-VA AMT 07";
label variable AMATRI07 "PHYS ASS T AMB VSTS-TRICARE AMT 07";
label variable AMAOFD07 "PHYS ASS T AMB VSTS -OTHER FED AMT 07";
label variable AMASTL07 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 07";
label variable AMAWCP07 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 07";
label variable AMAOPR07 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 07";
label variable AMAOPU07 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 07";
label variable AMAOSR07 "P A AMB VSTS- OTH UNCLASS SRCE AMT 07";
label variable AMTHER07 "# AMB PT/OT THRPY VISITS (OB+OP) 07";
label variable AMTTCH07 "PT/OC AMBULATORY VISIT CHARGES 07";
label variable AMTEXP07 "TOTL AMBULTRY (OB+OP) PT/OT EXP 07";
label variable AMTSLF07 "PT/OT AMB VISITS-SELF/FAMILY AMT 07";
label variable AMTMCR07 "PT/OT AMB VISITS-MEDICARE AMT 07";
label variable AMTMCD07 "PT/OT AMB VISITS-MEDICAID AMT 07";
label variable AMTPRV07 "PT/OT AMB VISITS-PRIVATE INS AMT 07";
label variable AMTVA07 "PT/OT AMB VISITS-VA AMT 07";
label variable AMTTRI07 "PT/OT AMB VISITS-TRICARE AMT 07";
label variable AMTOFD07 "PT/OT AMB VISITS -OTHER FED AMT 07";
label variable AMTSTL07 "PT/OT AMB VISITS-OTH ST/LOCL AMT 07";
label variable AMTWCP07 "PT/OT AMB VISITS-WORKERS COMP AMT 07";
label variable AMTOPR07 "PT/OT AMB VISITS - OTH PRIVATE AMT 07";
label variable AMTOPU07 "PT/OT AMB VISITS-OTH PUBLIC AMT 07";
label variable AMTOSR07 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 07";
label variable AMTOTC07 "# CALLS W/OFFICE & OUPAT DEPTS, 2007";
label variable AMDRC07 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2007";
label variable ERTOT07 "# EMERGENCY ROOM VISITS 07";
label variable ERTTCH07 "ER FACILITY + DR VISIT CHARGES 07";
label variable ERTEXP07 "TOTAL ER FACILITY + DR EXP 07";
label variable ERTSLF07 "ER -SELF/FAMILY AMT-(FAC+DR) 07";
label variable ERTMCR07 "ER -MEDICARE AMT-(FAC+DR) 07";
label variable ERTMCD07 "ER -MEDICAID AMT-(FAC+DR) 07";
label variable ERTPRV07 "ER -PRIV INS AMT-(FAC+DR) 07";
label variable ERTVA07 "ER -VA AMT-(FAC+DR) 07";
label variable ERTTRI07 "ER -TRICARE AMT-(FAC+DR) 07";
label variable ERTOFD07 "ER -OTHER FED AMT-(FAC+DR) 07";
label variable ERTSTL07 "ER -OTH ST/LOCAL AMT-(FAC+DR) 07";
label variable ERTWCP07 "ER -WORKERS COMP AMT-(FAC+DR) 07";
label variable ERTOPR07 "ER -OTH PRIVATE AMT-(FAC+DR) 07";
label variable ERTOPU07 "ER -OTH PUBLIC AMT-(FAC+DR) 07";
label variable ERTOSR07 "ER -OTH UNCLASS SRCE AMT-(FAC+DR) 07";
label variable ERFTCH07 "ER FACILITY VISIT CHARGES 07";
label variable ERFEXP07 "TOTAL ER FACILITY EXP 07";
label variable ERFSLF07 "ER-SELF/FAMILY AMT - FAC 07";
label variable ERFMCR07 "ER-MEDICARE AMT - FAC 07";
label variable ERFMCD07 "ER-MEDICAID AMT - FAC 07";
label variable ERFPRV07 "ER-PRIVATE INS AMT - FAC 07";
label variable ERFVA07 "ER-VA AMT - FAC 07";
label variable ERFTRI07 "ER-TRICARE AMT - FAC 07";
label variable ERFOFD07 "ER-OTHER FEDERAL AMT - FAC 07";
label variable ERFSTL07 "ER-OTH ST/LOCAL AMT - FAC 07";
label variable ERFWCP07 "ER-WORKERS COMP AMT - FAC 07";
label variable ERFOPR07 "ER-OTHER PRIVATE AMT - FAC 07";
label variable ERFOPU07 "ER-OTHER PUBLIC AMT - FAC 07";
label variable ERFOSR07 "ER-OTH UNCLASS SRCE AMT - FAC 07";
label variable ERDEXP07 "TOTAL EMERGENCY ROOM DR EXP 07";
label variable ERDTCH07 "ER DOCTOR VISIT CHARGES 07";
label variable ERDSLF07 "ER-SELF/FAMILY AMT - DR 07";
label variable ERDMCR07 "ER-MEDICARE AMT - DR 07";
label variable ERDMCD07 "ER-MEDICAID AMT - DR 07";
label variable ERDPRV07 "ER-PRIVATE INS AMT - DR 07";
label variable ERDVA07 "ER-VA AMT - DR 07";
label variable ERDTRI07 "ER-TRICARE AMT - DR 07";
label variable ERDOFD07 "ER-OTHER FED AMT - DR 07";
label variable ERDSTL07 "ER-OTH ST/LOCAL AMT - DR 07";
label variable ERDWCP07 "ER-WORKERS COMP AMT - DR 07";
label variable ERDOPR07 "ER - OTHER PRIVATE AMT - DR 07";
label variable ERDOPU07 "ER - OTHER PUBLIC AMT - DR 07";
label variable ERDOSR07 "ER-OTH UNCLASS SRCE AMT - DR 07";
label variable IPZERO07 "# ZERO-NIGHT HOSPITAL STAYS 07";
label variable ZIFTCH07 "ZERO-NITE IP STAY CHARGES - FAC 07";
label variable ZIFEXP07 "TOTAL ZERO-NITE STAYS FAC EXP 07";
label variable ZIFSLF07 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 07";
label variable ZIFMCR07 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 07";
label variable ZIFMCD07 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 07";
label variable ZIFPRV07 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 07";
label variable ZIFVA07 "ZERO-NITE IP STAZ-VA AMT-FAC 07";
label variable ZIFTRI07 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 07";
label variable ZIFOFD07 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 07";
label variable ZIFSTL07 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 07";
label variable ZIFWCP07 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 07";
label variable ZIFOPR07 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 07";
label variable ZIFOPU07 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 07";
label variable ZIFOSR07 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 07";
label variable ZIDEXP07 "TOTAL ZERO-NITE STAZ DR 07";
label variable ZIDTCH07 "ZERO-NITE IP STAY CHARGES - DR 07";
label variable ZIDSLF07 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 07";
label variable ZIDMCR07 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 07";
label variable ZIDMCD07 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 07";
label variable ZIDPRV07 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 07";
label variable ZIDVA07 "ZERO-NITE IP STAZ-VA AMT-DR 07";
label variable ZIDTRI07 "ZERO-NITE IP STAZ-TRICARE AMT-DR 07";
label variable ZIDOFD07 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 07";
label variable ZIDSTL07 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 07";
label variable ZIDWCP07 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 07";
label variable ZIDOPR07 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 07";
label variable ZIDOPU07 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 07";
label variable ZIDOSR07 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 07";
label variable IPDIS07 "# HOSPITAL DISCHARGES, 2007";
label variable IPTEXP07 "TOT HOSP IP FACILITY + DR EXP 07";
label variable IPTTCH07 "IP HOSP STAY CHARGES (FAC+DR) 07";
label variable IPTSLF07 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 07";
label variable IPTMCR07 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 07";
label variable IPTMCD07 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 07";
label variable IPTPRV07 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 07";
label variable IPTVA07 "IP HOSP STAZ-VA AMT-(FAC+DR) 07";
label variable IPTTRI07 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 07";
label variable IPTOFD07 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 07";
label variable IPTSTL07 "IP HOSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 07";
label variable IPTWCP07 "IP HOSP STAZ-WORKERS COMP AMT-(FAC+DR) 07";
label variable IPTOPR07 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 07";
label variable IPTOPU07 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 07";
label variable IPTOSR07 "IP HOSP STAZ-OTH UNCLASS SRCE AMT-(FAC+DR) 07";
label variable IPFEXP07 "TOT HOSP IP FACILITY EXP-INC 0 NITES 07";
label variable IPFTCH07 "IP HOSP STAY CHARGES - FAC 07";
label variable IPFSLF07 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 07";
label variable IPFMCR07 "IP HOSP STAZ-MEDICARE AMT-FAC 07";
label variable IPFMCD07 "IP HOSP STAZ-MEDICAID AMT-FAC 07";
label variable IPFPRV07 "IP HOSP STAZ-PRIV INS AMT-FAC 07";
label variable IPFVA07 "IP HOSP STAZ-VA AMT-FAC 07";
label variable IPFTRI07 "IP HOSP STAZ-TRICARE AMT-FAC 07";
label variable IPFOFD07 "IP HOSP STAZ-OTHER FED AMT-FAC 07";
label variable IPFSTL07 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 07";
label variable IPFWCP07 "IP HOSP STAZ-WORKERS COMP AMT-FAC 07";
label variable IPFOPR07 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 07";
label variable IPFOPU07 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 07";
label variable IPFOSR07 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 07";
label variable IPDEXP07 "TOTL HOSP STAZ DR EXP 07";
label variable IPDTCH07 "IP HOSP STAY CHARGES - DR 07";
label variable IPDSLF07 "IP HOSP STAZ-SELF/FAMILY AMT-DR 07";
label variable IPDMCR07 "IP HOSP STAZ-MEDICARE AMT- DR 07";
label variable IPDMCD07 "IP HOSP STAZ-MEDICAID AMT-DR 07";
label variable IPDPRV07 "IP HOSP STAZ-PRIV INS AMT- DR 07";
label variable IPDVA07 "IP HOSP STAZ-VA AMT-DR 07";
label variable IPDTRI07 "IP HOSP STAZ-TRICARE AMT-DR 07";
label variable IPDOFD07 "IP HOSP STAZ-OTHER FED AMT-DR 07";
label variable IPDSTL07 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 07";
label variable IPDWCP07 "IP HOSP STAZ-WORKERS COMP AMT-DR 07";
label variable IPDOPR07 "IP HOSP STAZ - OTH PRIVATE AMT-DR 07";
label variable IPDOPU07 "IP HOSP STAZ - OTH PUBLIC AMT-DR 07";
label variable IPDOSR07 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 07";
label variable IPNGTD07 "# NIGHTS IN HOSP FOR DISCHARGES, 2007";
label variable DVTOT07 "# DENTAL CARE VISITS 07";
label variable DVTTCH07 "TOTAL DENTAL CARE VISIT CHARGES 07";
label variable DVTEXP07 "TOTAL DENTAL CARE EXP 07";
label variable DVTSLF07 "ALL DENTAL CARE -SELF/FAMILY AMT 07";
label variable DVTMCR07 "ALL DENTAL CARE -MEDICARE AMT 07";
label variable DVTMCD07 "ALL DENTAL CARE -MEDICAID AMT 07";
label variable DVTPRV07 "ALL DENTAL CARE -PRIVATE INS AMT 07";
label variable DVTVA07 "ALL DENTAL CARE -VA AMT 07";
label variable DVTTRI07 "ALL DENTAL CARE -TRICARE AMT 07";
label variable DVTOFD07 "ALL DENTAL CARE -OTHER FEDRL AMT 07";
label variable DVTSTL07 "ALL DENTAL CARE -OTH ST/LOCAL AMT 07";
label variable DVTWCP07 "ALL DENTAL CARE -WORKERS COMP AMT 07";
label variable DVTOPR07 "ALL DENTAL CARE - OTH PRIVATE AMT 07";
label variable DVTOPU07 "ALL DENTAL CARE - OTH PUBLIC AMT 07";
label variable DVTOSR07 "ALL DENT CARE-OT UNCLASS SRCE AMT 07";
label variable DVGEN07 "# GENERAL DENTIST VISITS 07";
label variable DVGTCH07 "GENERAL DENTAL CARE VISIT CHARGES 07";
label variable DVGEXP07 "TOTAL GENERAL DENTIST EXP 07";
label variable DVGSLF07 "GNRL DENTAL VISITS -SELF/FAM AMT 07";
label variable DVGMCR07 "GNRL DENTAL VISITS -MEDICARE AMT 07";
label variable DVGMCD07 "GNRL DENTAL VISITS -MEDICAID AMT 07";
label variable DVGPRV07 "GNRL DENTAL VISITS -PRIVATE INS AMT 07";
label variable DVGVA07 "GNRL DENTAL VISITS -VA AMT 07";
label variable DVGTRI07 "GNRL DENTAL VISITS-TRICARE AMT 07";
label variable DVGOFD07 "GNRL DENTAL VISITS- OTHER FED AMT 07";
label variable DVGSTL07 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 07";
label variable DVGWCP07 "GNRL DENTAL VISITS - WORKERS COMP AMT 07";
label variable DVGOPR07 "GNRL DENTAL VISITS - OTH PRIVATE AMT 07";
label variable DVGOPU07 "GNRL DENTAL VISITS - OTH PUBLIC AMT 07";
label variable DVGOSR07 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 07";
label variable DVORTH07 "# ORTHODONTIST VISITS 07";
label variable DVOTCH07 "ORTHODONTIST VISIT CHARGES 07";
label variable DVOEXP07 "TOTAL ORTHODONTIST EXP 07";
label variable DVOSLF07 "ORTHODONTIST VISITS -SELF/FAMILY AMT 07";
label variable DVOMCR07 "ORTHODONTIST VISITS -MEDICARE AMT 07";
label variable DVOMCD07 "ORTHODONTIST VISITS -MEDICAID AMT 07";
label variable DVOPRV07 "ORTHODONTIST VISITS -PRIVATE INS AMT 07";
label variable DVOVA07 "ORTHODONTIST VISITS-VA AMT 07";
label variable DVOTRI07 "ORTHODONTIST VISITS-TRICARE AMT 07";
label variable DVOOFD07 "ORTHODONTIST VISITS-OTHR FED AMT 07";
label variable DVOSTL07 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 07";
label variable DVOWCP07 "ORTHODONTIST VISITS-WORKERS COMP AMT 07";
label variable DVOOPR07 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 07";
label variable DVOOPU07 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 07";
label variable DVOOSR07 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 07";
label variable HHTOTD07 "# HOME HEALTH PROVIDER DAYS, 2007";
label variable HHAGD07 "# AGENCY HOME HEALTH PROVIDER DAYS 07";
label variable HHATCH07 "HOME HEALTH AGENCY VISIT CHARGES 07";
label variable HHAEXP07 "TOTAL HOME HEALTH AGENCY EXP 07";
label variable HHASLF07 "HOME HLTH AGENCY -SELF/FAMILY AMT 07";
label variable HHAMCR07 "HOME HLTH AGENCY -MEDICARE AMT 07";
label variable HHAMCD07 "HOME HLTH AGENCY -MEDICAID AMT 07";
label variable HHAPRV07 "HOME HLTH AGENCY -PRIVATE INS AMT 07";
label variable HHAVA07 "HOME HLTH AGENCY-VA AMT 07";
label variable HHATRI07 "HOME HLTH AGENCY-TRICARE AMT 07";
label variable HHAOFD07 "HOME HLTH AGENCY-OTHER FED AMT 07";
label variable HHASTL07 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 07";
label variable HHAWCP07 "HOME HLTH AGENCY- WORKERS COMP AMT 07";
label variable HHAOPR07 "HOME HLTH AGENCY - OTH PRIVATE AMT 07";
label variable HHAOPU07 "HOME HLTH AGENCY - OTH PUBLIC AMT 07";
label variable HHAOSR07 "H HLTH AGENCY - OT UNCLASS SRCE AMT 07";
label variable HHINDD07 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 07";
label variable HHNTCH07 "HOME HEALTH NON-AGENCY VISIT CHARGES 07";
label variable HHNEXP07 "TOTAL HOME HEALTH NON-AGNCY EXP 07";
label variable HHNSLF07 "HOME HLTH NON-AGNCY -SELF/FAM AMT 07";
label variable HHNMCR07 "HOME HLTH NON-AGNCY -MEDICARE AMT 07";
label variable HHNMCD07 "HOME HLTH NON-AGNCY -MEDICAID AMT 07";
label variable HHNPRV07 "HOME HLTH NON-AGNCY -PRIV INS AMT 07";
label variable HHNVA07 "HOME HLTH NON-AGNCY-VA AMT 07";
label variable HHNTRI07 "HOME HLTH NON-AGNCY-TRICARE AMT 07";
label variable HHNOFD07 "HOME HLTH NON-AGNCY-OTHR FED AMT 07";
label variable HHNSTL07 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 07";
label variable HHNWCP07 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 07";
label variable HHNOPR07 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 07";
label variable HHNOPU07 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 07";
label variable HHNOSR07 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 07";
label variable HHINFD07 "# INFORMAL HOME HEALTH PROVIDER DAYS 07";
label variable VISEXP07 "TOTAL GLASSES/CONTACT LENS EXP 07";
label variable VISTCH07 "GLASSES/CONTACT LENSES CHARGES 07";
label variable VISSLF07 "GLASSES/CNTCT LENSES -SELF/FAM AMT 07";
label variable VISMCR07 "GLASSES/CNTCT LENSES-MEDICARE AMT 07";
label variable VISMCD07 "GLASSES/CNTCT LENSES-MEDICAID AMT 07";
label variable VISPRV07 "GLASSES/CNTCT LENSES-PRIV INS AMT 07";
label variable VISVA07 "GLASSES/CNTCT LENSES-VA AMT 07";
label variable VISTRI07 "GLASSES/LENSES-TRICARE AMT 07";
label variable VISOFD07 "GLASSES/CNTCT LENSES-OTHR FED AMT 07";
label variable VISSTL07 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 07";
label variable VISWCP07 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 07";
label variable VISOPR07 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 07";
label variable VISOPU07 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 07";
label variable VISOSR07 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 07";
label variable OTHTCH07 "OTHER EQUP/SUPPLIES CHARGES 07";
label variable OTHEXP07 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 07";
label variable OTHSLF07 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 07";
label variable OTHMCR07 "OTHER EQUP/SUPPLIES-MEDICARE AMT 07";
label variable OTHMCD07 "OTHER EQUP/SUPPLIES-MEDICAID AMT 07";
label variable OTHPRV07 "OTHER EQUP/SUPPLIES-PRIV INS AMT 07";
label variable OTHVA07 "OTHER EQUP/SUPPLY-VA AMT 07";
label variable OTHTRI07 "OTHER EQUP/SUPPLY-TRICARE AMT 07";
label variable OTHOFD07 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 07";
label variable OTHSTL07 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 07";
label variable OTHWCP07 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 07";
label variable OTHOPR07 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 07";
label variable OTHOPU07 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 07";
label variable OTHOSR07 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 07";
label variable RXTOT07 "# PRESC MEDS INCL REFILLS 07";
label variable RXEXP07 "TOTAL RX-EXP 07";
label variable RXSLF07 "TOTAL RX-SELF/FAMILY AMT 07";
label variable RXMCR07 "TOTAL RX--MEDICARE AMT 07";
label variable RXMCD07 "TOTAL RX-MEDICAID AMT 07";
label variable RXPRV07 "TOTAL RX-PRIVATE INS AMT 07";
label variable RXVA07 "TOTAL RX-VA AMT 07";
label variable RXTRI07 "TOTAL RX-TRICARE AMT 07";
label variable RXOFD07 "TOTAL RX-OTHER FED AMT 07";
label variable RXSTL07 "TOTAL RX-OTHER ST/LOCAL AMT 07";
label variable RXWCP07 "TOTAL RX-WORKERS COMP AMT 07";
label variable RXOPR07 "TOTAL RX - OTH PRIVATE AMT 07";
label variable RXOPU07 "TOTAL RX - OTH PUBLIC AMT 07";
label variable RXOSR07 "TOT RX-OTH UNCLASS SRCE AMT 07";
label variable TOTPTR07 "TOTAL AMT PAID BY PRV & TRI 07";
label variable TOTOTH07 "TOTAL AMT PAID BY OTH COMBINED 07";
label variable OBVPTR07 "ALL OFFICE VISITS -PRV & TRI AMT 07";
label variable OBVOTH07 "ALL OFFICE VISITS -OTH COMBINED AMT 07";
label variable OBDPTR07 "DR OFFICE VISITS -PRV & TRI AMT 07";
label variable OBDOTH07 "DR OFFICE VISITS -OTH COMBINED AMT 07";
label variable OBOPTR07 "NON-DR OFF VISTS -PRV & TRI AMT 07";
label variable OBOOTH07 "NON-DR OFF VISTS -OTH COMBINED AMT 07";
label variable OBCPTR07 "CHIRO OFF VISITS -PRV & TRI AMT 07";
label variable OBCOTH07 "CHIRO OFF VISITS -OTH COMBINED AMT 07";
label variable OBNPTR07 "NURSE/PRAC OFF VSTS -PRV & TRI AMT 07";
label variable OBNOTH07 "NURSE/PRAC OFF VSTS -OTH COMBINED AMT 07";
label variable OBEPTR07 "OPTOMETRIST OFF VSTS -PRV & TRI AMT 07";
label variable OBEOTH07 "OPTOMETRIST OFF VSTS -OTH COMBINED AMT 07";
label variable OBAPTR07 "PHYS ASST OFF VSTS -PRV & TRI AMT 07";
label variable OBAOTH07 "PHYS ASST OFF VSTS -OTH COMBINED AMT 07";
label variable OBTPTR07 "PT/OT OFF VISITS -PRV & TRI AMT 07";
label variable OBTOTH07 "PT/OT OFF VISITS -OTH COMBINED AMT 07";
label variable OPTPTR07 "ALL OPD VISITS -PRV & TRI AMT (FAC+DR) 07";
label variable OPTOTH07 "ALL OPD VISITS-OTH COMBINED AMT(FAC+DR) 07";
label variable OPFPTR07 "ALL OPD VISITS -PRV & TRI AMT-FAC 07";
label variable OPFOTH07 "ALL OPD VISITS -OTH COMBINED AMT-FAC 07";
label variable OPDPTR07 "ALL OPD VISITS -PRV & TRI AMT -DR 07";
label variable OPDOTH07 "ALL OPD VISITS -OTH COMBINED AMT-DR 07";
label variable OPVPTR07 "OPD DR VISITS -PRV & TRI AMT-FAC 07";
label variable OPVOTH07 "OPD DR VISITS -OTH COMBINED AMT-FAC 07";
label variable OPSPTR07 "OPD DR VISITS -PRV & TRI AMT-DR 07";
label variable OPSOTH07 "OPD DR VISITS -OTH COMBINED AMT-DR 07";
label variable OPOPTR07 "OPD NON-DR VISITS -PRV & TRI AMT-FAC 07";
label variable OPOOTH07 "OPD NON-DR VISITS -OTH COMBINED AMT-FAC 07";
label variable OPPPTR07 "OPD NON-DR VISITS -PRV & TRI AMT-DR 07";
label variable OPPOTH07 "OPD NON-DR VISITS -OTH COMBINED AMT-DR 07";
label variable AMCPTR07 "CHIRO AMB VISITS -PRV & TRI AMT 07";
label variable AMCOTH07 "CHIRO AMB VISITS -OTH COMBINED AMT 07";
label variable AMNPTR07 "NRS/PRAC AMB VSTS -PRV & TRI AMT 07";
label variable AMNOTH07 "NRS/PRAC AMB VSTS -OTH COMBINED AMT 07";
label variable AMEPTR07 "OPTMTRIST AMB VSTS -PRV & TRI AMT 07";
label variable AMEOTH07 "OPTMTRIST AMB VSTS -OTH COMBINED AMT 07";
label variable AMAPTR07 "PHYS ASS T AMB VSTS -PRV & TRI AMT 07";
label variable AMAOTH07 "PHYS ASS T AMB VSTS -OTH COMBINED AMT 07";
label variable AMTPTR07 "PT/OT AMB VISITS -PRV & TRI AMT 07";
label variable AMTOTH07 "PT/OT AMB VISITS -OTH COMBINED AMT 07";
label variable ERTPTR07 "ER-PRV & TRI AMT (FAC+DR) 07";
label variable ERTOTH07 "ER -OTH COMBINED AMT (FAC+DR) 07";
label variable ERFPTR07 "ER-PRV & TRI AMT - FAC 07";
label variable ERFOTH07 "ER-OTH COMBINED AMT - FAC 07";
label variable ERDPTR07 "ER-PRV & TRI AMT - DR 07";
label variable ERDOTH07 "ER-OTH COMBINED AMT - DR 07";
label variable ZIFPTR07 "ZERO-NITE IP STAZ-PRV & TRI AMT-FAC 07";
label variable ZIFOTH07 "ZERO-NITE IP STAZ -OTH COMBINED AMT-FAC 07";
label variable ZIDPTR07 "ZERO-NITE IP STAZ-PRV & TRI AMT-DR 07";
label variable ZIDOTH07 "ZERO-NITE IP STAZ-OTH COMBINED AMT-DR 07";
label variable IPTPTR07 "IP HOSP STAZ-PRV & TRI AMT (FAC+DR) 07";
label variable IPTOTH07 "IP HOSP STAZ -OTH COMBINED AMT (FAC+DR) 07";
label variable IPFPTR07 "IP HOSP STAZ-PRV & TRI AMT-FAC 07";
label variable IPFOTH07 "IP HOSP STAZ-OTH COMBINED AMT-FAC 07";
label variable IPDPTR07 "IP HOSP STAZ-PRV & TRI AMT-DR 07";
label variable IPDOTH07 "IP HOSP STAZ-OTH COMBINED AMT-DR 07";
label variable DVTPTR07 "ALL DENTAL CARE -PRV & TRI AMT 07";
label variable DVTOTH07 "ALL DENTAL CARE -OTH COMBINED AMT 07";
label variable DVGPTR07 "GNRL DENTAL VISITS -PRV & TRI AMT 07";
label variable DVGOTH07 "GNRL DENTAL VISITS -OTH COMBINED AMT 07";
label variable DVOPTR07 "ORTHODONTIST VISITS -PRV & TRI AMT 07";
label variable DVOOTH07 "ORTHODONTIST VISITS -OTH COMBINED AMT 07";
label variable HHAPTR07 "HOME HLTH AGENCY -PRV & TRI AMT 07";
label variable HHAOTH07 "HOME HLTH AGENCY -OTH COMBINED AMT 07";
label variable HHNPTR07 "HOME HLTH NON-AGNCY -PRV & TRI AMT 07";
label variable HHNOTH07 "HOME HLTH NON-AGNCY -OTH COMBINED AMT 07";
label variable VISPTR07 "GLASSES/CNTCT LENSES -PRV & TRI AMT 07";
label variable VISOTH07 "GLASSES/CNTCT LENSES -OTH COMBINED AMT 07";
label variable OTHPTR07 "OTHER EQUP/SUPPLY -PRV & TRI AMT 07";
label variable OTHOTH07 "OTHER EQUP/SUPPLY -OTH COMBINED AMT 07";
label variable RXPTR07 "TOTAL RX-PRV & TRI AMT 07";
label variable RXOTH07 "TOTAL RX-OTH COMBINED AMT 07";
label variable PERWT07F "FINAL PERSON WEIGHT, 2007";
label variable FAMWT07F "FINAL FAMILY WEIGHT, 2007";
label variable FAMWT07C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/07";
label variable SAQWT07F "FINAL SAQ PERSON WEIGHT, 2007";
label variable DIABW07F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2007";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2007";


*DEFINE VALUE LABELS FOR REPORTS;
label define H1130001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H1130002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1130003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1130004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H1130005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1130008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1130010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H1130014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1130016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1130018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1130020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1130021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1130022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1130025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1130026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H1130027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130030X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H1130031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1130040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H1130042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1130043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H1130044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1130048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1130051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H1130052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1130055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H1130057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1130059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H1130060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H1130061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1130062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130064X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1130065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130089X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         160 "$160" ;

label define H1130090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130091X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130097X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         263 "$263" ;

label define H1130098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130101X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130104X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         254 "$254" ;

label define H1130105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130106X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         52 "$52" ;

label define H1130107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130116X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         25 "$25"
         45 "$45" ;

label define H1130117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130124X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130139X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         284 "$284" ;

label define H1130140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130141X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130142X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130143X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130144X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130145X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130146X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130147X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130148X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130149X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130150X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130151X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130152X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130154X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1130156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H1130157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H1130174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2006 "2006 YEAR"
         2007 "2007 YEAR" ;

label define H1130178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2007 "2007 YEAR" ;

label define H1130179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2007 "2007 YEAR"
         2008 "2008 YEAR" ;

label define H1130180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130184X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1130188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1130191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1130192X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1130193X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H1130194X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1130195X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130196X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130197X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H1130199X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1130203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130205X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1130206X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H1130207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H1130208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1130212X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130216X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1130217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130221X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130222X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1130224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130240X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1130243X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1130244X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H1130245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130247X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H1130248X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1130249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1130252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1130263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H1130264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H1130266X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130267X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130268X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H1130270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1130271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130272X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130273X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1130275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1130276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H1130277X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1130278X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1130279X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H1130280X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130281X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1130282X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1130286X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130287X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1130291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130293X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130294X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H1130295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H1130296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE BLOOD TEST" ;

label define H1130297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H1130298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130311X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130312X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130313X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130314X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130331X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130332X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1058 "$1058" ;

label define H1130333X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130334X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130335X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130337X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130338X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130339X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130340X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130341X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130342X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1325 "$1325"
         65 "$65" ;

label define H1130343X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130344X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130345X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130346X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130347X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130348X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130349X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130350X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130351X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130352X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130353X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130354X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130355X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130356X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130357X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130358X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130359X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130360X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H1130363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H1130364X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1130365X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1130366X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1130367X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H1130368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H1130370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H1130371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H1130372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130374X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130375X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1130376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2007 "2007 YEAR" ;

label define H1130377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2006 "2006 YEAR"
         2007 "2007 YEAR" ;

label define H1130378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2007 "2007 YEAR" ;

label define H1130379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2007 "2007 YEAR"
         2008 "2008 YEAR" ;

label define H1130380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130381X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130382X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130383X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130384X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130385X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         62 "$62" ;

label define H1130386X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130387X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130388X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130389X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130390X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130391X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130392X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130393X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130394X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130395X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130396X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130397X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130398X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130399X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130400X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130401X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130402X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130403X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130404X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130405X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130406X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130407X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130408X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130409X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130410X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130411X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130412X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130413X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130414X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130415X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130416X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130417X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130418X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130419X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130420X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130421X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130422X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130423X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130424X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130425X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130426X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130427X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130428X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130429X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130430X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130438X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130439X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1130440X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1130441X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1130442X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H1130443X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130444X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130445X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H1130446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H1130448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1130449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H1130450X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1130451X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H1130452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130453X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130454X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130456X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130457X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1130458X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1130459X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1130460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H1130461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1130462X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H1130463X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1130464X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS" ;

label define H1130465X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130466X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1130467X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130468X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130469X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130470X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130471X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H1130472X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130473X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130475X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130476X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130479X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130480X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130481X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130482X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130483X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         835 "$835" ;

label define H1130484X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130485X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130486X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130487X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130488X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130489X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130490X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130491X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2440 "$2440"
         2984 "$2984" ;

label define H1130492X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130493X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130494X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130495X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130496X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130497X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130498X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130499X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130500X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         6144 "$6144" ;

label define H1130501X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130502X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130503X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130504X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130505X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130506X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130507X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1588 "$1588"
         275 "$275" ;

label define H1130508X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130509X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         60 "$60" ;

label define H1130510X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         216 "$216" ;

label define H1130511X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130512X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130513X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130514X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H1130515X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H1130516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H1130517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1130518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1130519X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1130520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1130521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H1130522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130523X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130524X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130562X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130563X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130564X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130565X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130566X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130567X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130568X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130597X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1130598X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1130599X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H1130600X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $70.91"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130601X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $70.91"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130602X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $70.91"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130603X
         0 "0 NO"
         1 "1 YES" ;

label define H1130604X
         0 "0 NO"
         1 "1 YES" ;

label define H1130605X
         0 "0 NO"
         1 "1 YES" ;

label define H1130606X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130607X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130608X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130609X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130610X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130611X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130612X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130613X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130614X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130615X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130616X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1130617X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1130618X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H1130619X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130620X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130621X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130622X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130623X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130624X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130625X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130626X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130627X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130628X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130629X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2007"
         2 "2 NOT IN-SCOPE ON 12/31/2007" ;

label define H1130630X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/07"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1130631X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/07"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1130632X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/07"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1130633X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/07"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H1130634X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2007"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2007" ;

label define H1130635X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H1130636X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130637X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130639X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130640X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130641X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130642X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130643X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130645X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130646X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130647X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130648X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130649X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1130650X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130651X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H1130652X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130653X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130654X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130655X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130656X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         90 "$90" ;

label define H1130657X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130658X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130659X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130660X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130661X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130662X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130663X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130664X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130665X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130666X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130667X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130668X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130669X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130670X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130671X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130672X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130673X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130674X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130675X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130676X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130677X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130678X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130679X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130680X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130681X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130682X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130683X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130684X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130685X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130686X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130687X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130688X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130689X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130690X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130691X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130692X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130693X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130694X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130695X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130696X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130697X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130698X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130699X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130700X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130701X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130702X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130703X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1130704X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130705X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130706X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1130707X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1130708X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H1130709X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130710X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130711X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130712X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130713X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130714X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H1130715X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1130716X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130717X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H1130718X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130719X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130720X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130721X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130722X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130723X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130724X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H1130725X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1130726X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130727X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1130728X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H1130729X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1130730X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1130731X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H1130732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130747X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130757X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130758X
         1 "1 YES"
         2 "2 NO" ;

label define H1130759X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130760X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130761X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1130762X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1130763X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1130764X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130765X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130766X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130769X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130770X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130771X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130772X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1130773X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1130774X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H1130775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130776X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130777X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130778X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130779X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130780X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130781X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130782X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130783X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130784X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130785X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130787X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130789X
         1 "1 YES"
         2 "2 NO" ;

label define H1130790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130791X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130792X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130793X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130794X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130795X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130796X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130797X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130798X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130806X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130807X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130808X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130809X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130810X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130811X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130812X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130813X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130814X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H1130815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130816X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1130817X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130818X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130819X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1130820X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130821X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1130822X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1130823X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1130824X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130825X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H1130826X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130827X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130828X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130829X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1130830X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130831X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1130832X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1130833X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1130834X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1130835X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130836X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130837X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130838X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130839X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1130840X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1130841X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H1130842X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1130843X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1130844X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1130845X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H1130846X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130847X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130848X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1130849X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1130850X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130851X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130852X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$70.91"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130853X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$70.91"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130854X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$70.91"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130855X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130856X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130857X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130858X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130859X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130860X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H1130861X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130862X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130863X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130864X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130865X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130866X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1130867X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1130868X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1130869X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1130870X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H1130871X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130872X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130874X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130875X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130876X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130877X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130878X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130879X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130880X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130881X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130882X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130883X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130884X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130885X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130886X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130887X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130888X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130889X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130890X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130891X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130892X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130893X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130894X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         160 "$160" ;

label define H1130895X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130896X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130897X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130898X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130899X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130900X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130901X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130902X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         263 "$263" ;

label define H1130903X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130904X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130905X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130906X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130907X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130908X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130909X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130910X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130911X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130912X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130913X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130914X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130915X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130916X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130917X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130918X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130919X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130920X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130921X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130922X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130923X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130924X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130925X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         254 "$254" ;

label define H1130926X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130927X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         52 "$52" ;

label define H1130928X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130929X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130930X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130931X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130932X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130933X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130934X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130935X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130936X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130937X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         25 "$25"
         45 "$45" ;

label define H1130938X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130939X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130940X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130941X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130942X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130943X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130944X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130945X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130946X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130947X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130948X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130949X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130950X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130951X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130952X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130953X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130954X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130955X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130956X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130957X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130958X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130959X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130960X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130961X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130962X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130963X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130964X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130965X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130966X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130967X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130968X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130969X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130970X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130971X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130972X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130973X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130974X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130975X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130976X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130977X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         284 "$284" ;

label define H1130978X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130979X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         186 "$186"
         662 "$662"
         77 "$77" ;

label define H1130980X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130982X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130983X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130984X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130985X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130986X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130987X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130988X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130991X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130997X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130998X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1130999X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131001X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131004X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131005X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131006X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131007X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1131008X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1131009X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H1131010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131019X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131020X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131021X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131022X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131023X
         1 "1 YES"
         2 "2 NO" ;

label define H1131024X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131025X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131026X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131027X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131028X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131029X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131030X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131031X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131032X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131033X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131034X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131035X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131036X
         1 "1 YES"
         2 "2 NO" ;

label define H1131037X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131038X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131039X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131040X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131041X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131042X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131043X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131044X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131045X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131049X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131051X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131054X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131062X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131091X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131097X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131101X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131106X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131124X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131139X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131141X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131142X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131143X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131144X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131145X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131146X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131147X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131148X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131149X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131150X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131151X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131152X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131153X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131154X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131155X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131156X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131157X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131158X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131159X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131160X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131164X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131165X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131166X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131167X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131168X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131172X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         5 "$5" ;

label define H1131173X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131174X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131175X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131176X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131177X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131178X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131180X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131181X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131182X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131183X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131184X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131185X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131186X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131187X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131205X
         11 "11 PANEL 11"
         12 "12 PANEL 12" ;

label define H1131206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1131207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131208X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131209X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131211X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131212X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131219X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131220X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131221X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131224X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131225X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131226X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131227X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131228X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131229X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131230X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131231X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131240X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131243X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1131244X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131245X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131246X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131247X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1131248X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1131249X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H1131250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H1131251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131252X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H1131256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1131261X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131262X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131263X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1131268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1131269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H1131270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131273X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1131274X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1131275X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H1131276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H1131278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H1131279X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131280X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131281X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131282X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131283X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131284X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131285X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131286X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131287X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131288X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131289X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131290X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131291X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131292X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131293X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131294X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131295X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131296X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131297X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131298X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131299X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131300X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131301X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131302X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131303X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131304X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131305X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131306X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131307X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131308X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131309X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131310X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131311X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131312X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131313X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131314X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131315X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H1131316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131319X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1131320X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1131321X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H1131322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131324X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131325X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131326X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131327X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131328X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131329X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131330X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131331X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131332X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131333X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131334X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131335X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131336X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131337X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131338X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131339X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131340X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131341X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131342X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131343X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131344X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131345X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131346X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131347X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131348X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131349X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131350X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131351X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131352X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131368X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H1131369X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1131370X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1131371X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1131372X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H1131373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131385X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131386X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131387X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131388X
         1 "1 YES"
         2 "2 NO" ;

label define H1131389X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131390X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131391X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131392X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131393X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131394X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H1131395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H1131396X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1131397X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1131398X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H1131399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131411X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131419X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131421X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1131422X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1131423X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H1131424X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H1131425X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H1131426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1131427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1131428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131430X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131433X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131434X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1131435X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1131436X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1131437X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H1131438X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1131439X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1131440X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1131441X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H1131442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H1131443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131444X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131445X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1131447X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1131448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1131449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 FOSTER SISTER"
         48 "48 FOSTER BROTHER"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H1131450X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H1131451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1131452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1131453X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H1131454X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131455X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131456X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1131457X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1131458X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1131459X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H1131460X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1131461X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1131462X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1131463X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H1131464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131469X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131474X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131479X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131480X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131481X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131482X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131483X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H1131484X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1131486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131487X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131488X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1131489X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131490X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131491X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H1131493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131494X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131496X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131497X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H1131499X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H1131500X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1131501X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1131502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131503X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131504X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131506X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131507X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1131508X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1131509X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1131510X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H1131511X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1131512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1131513X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1131514X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H1131515X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1131516X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H1131517X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H1131519X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131520X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1131522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1131523X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H1131524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131541X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131542X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1131544X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1131545X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H1131546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131547X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131548X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1131550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1131551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1131554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H1131555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H1131561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1131562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1131563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H1131564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H1131566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131567X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131568X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131569X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131570X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131571X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131572X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131573X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131574X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131575X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131576X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131577X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131578X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131579X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131580X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131581X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131582X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131583X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131584X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1131585X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131592X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131593X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131594X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131599X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131600X
         1 "1 YES"
         2 "2 NO" ;

label define H1131601X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131602X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131603X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131606X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131607X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131608X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131609X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131610X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131611X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131612X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131613X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131614X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131615X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131616X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131617X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131618X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H1131619X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV  BY TRICARE/CHAMPVA" ;

label define H1131620X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131621X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H1131622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131623X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131625X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H1131626X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131627X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131628X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131630X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H1131631X
         1 "1 YES"
         2 "2 NO" ;

label define H1131632X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131633X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131634X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131635X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131636X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131637X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H1131638X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131639X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131640X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131641X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H1131642X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131643X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131644X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131645X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131646X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131647X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131648X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131649X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131650X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131651X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131652X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131653X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131654X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131655X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131656X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131657X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         327 "$327" ;

label define H1131658X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131659X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131667X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131668X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131669X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131670X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131671X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131672X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131673X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131674X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131675X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H1131676X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1131677X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131678X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131679X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131680X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H1131681X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131682X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131683X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131684X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131685X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131686X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131687X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131688X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131689X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H1131690X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131691X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131692X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131693X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131694X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131695X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131696X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1131697X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H1131698X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131699X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131700X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131701X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H1131702X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131703X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H1131704X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1131705X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H1131706X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1131707X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H1131708X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H1131709X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 INSURANCE-RELATED REASONS"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H1131710X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131711X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131712X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131713X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131714X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131715X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131716X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16"
         2205 "$2205" ;

label define H1131717X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131718X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131719X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131720X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131721X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131722X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131723X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131724X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131725X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         585 "$585" ;

label define H1131726X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131727X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131728X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131729X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131730X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131731X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131732X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         8497 "$8497" ;

label define H1131733X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131734X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131735X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131736X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131737X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131738X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H1131739X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         421 "$421"
         4735 "$4735" ;

label define H1131740X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         258 "$258"
         67 "$67" ;

label define H1131741X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H1130001X;
label value ACTDTY31 H1130002X;
label value ACTDTY42 H1130003X;
label value ACTDTY53 H1130004X;
label value ACTLIM31 H1130005X;
label value ACTLIM53 H1130006X;
label value ADAPPT42 H1130007X;
label value ADCAPE42 H1130008X;
label value ADCLIM42 H1130009X;
label value ADCMPD42 H1130010X;
label value ADCMPM42 H1130011X;
label value ADCMPY42 H1130012X;
label value ADDAYA42 H1130013X;
label value ADDOWN42 H1130014X;
label value ADDPRS42 H1130015X;
label value ADDRBP42 H1130016X;
label value ADEFRT42 H1130017X;
label value ADEXPL42 H1130018X;
label value ADGENH42 H1130019X;
label value ADHECR42 H1130020X;
label value ADHOPE42 H1130021X;
label value ADILCR42 H1130022X;
label value ADILWW42 H1130023X;
label value ADINSA42 H1130024X;
label value ADINSB42 H1130025X;
label value ADINTR42 H1130026X;
label value ADL3MO31 H1130027X;
label value ADL3MO42 H1130028X;
label value ADL3MO53 H1130029X;
label value ADLANG42 H1130030X;
label value ADLHLP31 H1130031X;
label value ADLHLP42 H1130032X;
label value ADLHLP53 H1130033X;
label value ADLIST42 H1130034X;
label value ADMALS42 H1130035X;
label value ADMWLM42 H1130036X;
label value ADNDCR42 H1130037X;
label value ADNECP42 H1130038X;
label value ADNERV42 H1130039X;
label value ADNRGY42 H1130040X;
label value ADNSMK42 H1130041X;
label value ADOVER42 H1130042X;
label value ADPAIN42 H1130043X;
label value ADPALS42 H1130044X;
label value ADPRRE42 H1130045X;
label value ADPRTM42 H1130046X;
label value ADPRX42 H1130047X;
label value ADPWLM42 H1130048X;
label value ADRESP42 H1130049X;
label value ADREST42 H1130050X;
label value ADRISK42 H1130051X;
label value ADRTCR42 H1130052X;
label value ADRTWW42 H1130053X;
label value ADSAD42 H1130054X;
label value ADSMOK42 H1130055X;
label value ADSOCA42 H1130056X;
label value ADSPEC42 H1130057X;
label value ADUPRO42 H1130058X;
label value ADWRTH42 H1130059X;
label value AFDC07 H1130060X;
label value AFTHOU42 H1130061X;
label value AIDHLP31 H1130062X;
label value AIDHLP53 H1130063X;
label value ALIIMP07 H1130064X;
label value ALIMP07X H1130065X;
label value AMAEXP07 H1130066X;
label value AMAMCD07 H1130067X;
label value AMAMCR07 H1130068X;
label value AMAOFD07 H1130069X;
label value AMAOPR07 H1130070X;
label value AMAOPU07 H1130071X;
label value AMAOSR07 H1130072X;
label value AMAOTH07 H1130073X;
label value AMAPRV07 H1130074X;
label value AMAPTR07 H1130075X;
label value AMASLF07 H1130076X;
label value AMASST07 H1130077X;
label value AMASTL07 H1130078X;
label value AMATCH07 H1130079X;
label value AMATRI07 H1130080X;
label value AMAVA07 H1130081X;
label value AMAWCP07 H1130082X;
label value AMCEXP07 H1130083X;
label value AMCHIR07 H1130084X;
label value AMCMCD07 H1130085X;
label value AMCMCR07 H1130086X;
label value AMCOFD07 H1130087X;
label value AMCOPR07 H1130088X;
label value AMCOPU07 H1130089X;
label value AMCOSR07 H1130090X;
label value AMCOTH07 H1130091X;
label value AMCPRV07 H1130092X;
label value AMCPTR07 H1130093X;
label value AMCSLF07 H1130094X;
label value AMCSTL07 H1130095X;
label value AMCTCH07 H1130096X;
label value AMCTRI07 H1130097X;
label value AMCVA07 H1130098X;
label value AMCWCP07 H1130099X;
label value AMDRC07 H1130100X;
label value AMEEXP07 H1130101X;
label value AMEMCD07 H1130102X;
label value AMEMCR07 H1130103X;
label value AMEOFD07 H1130104X;
label value AMEOPR07 H1130105X;
label value AMEOPU07 H1130106X;
label value AMEOSR07 H1130107X;
label value AMEOTH07 H1130108X;
label value AMEPRV07 H1130109X;
label value AMEPTR07 H1130110X;
label value AMESLF07 H1130111X;
label value AMESTL07 H1130112X;
label value AMETCH07 H1130113X;
label value AMETRI07 H1130114X;
label value AMEVA07 H1130115X;
label value AMEWCP07 H1130116X;
label value AMNEXP07 H1130117X;
label value AMNMCD07 H1130118X;
label value AMNMCR07 H1130119X;
label value AMNOFD07 H1130120X;
label value AMNOPR07 H1130121X;
label value AMNOPU07 H1130122X;
label value AMNOSR07 H1130123X;
label value AMNOTH07 H1130124X;
label value AMNPRV07 H1130125X;
label value AMNPTR07 H1130126X;
label value AMNSLF07 H1130127X;
label value AMNSTL07 H1130128X;
label value AMNTCH07 H1130129X;
label value AMNTRI07 H1130130X;
label value AMNURS07 H1130131X;
label value AMNVA07 H1130132X;
label value AMNWCP07 H1130133X;
label value AMOPTO07 H1130134X;
label value AMTEXP07 H1130135X;
label value AMTHER07 H1130136X;
label value AMTMCD07 H1130137X;
label value AMTMCR07 H1130138X;
label value AMTOFD07 H1130139X;
label value AMTOPR07 H1130140X;
label value AMTOPU07 H1130141X;
label value AMTOSR07 H1130142X;
label value AMTOTC07 H1130143X;
label value AMTOTH07 H1130144X;
label value AMTPRV07 H1130145X;
label value AMTPTR07 H1130146X;
label value AMTSLF07 H1130147X;
label value AMTSTL07 H1130148X;
label value AMTTCH07 H1130149X;
label value AMTTRI07 H1130150X;
label value AMTVA07 H1130151X;
label value AMTWCP07 H1130152X;
label value ANGIDX H1130153X;
label value ANYLIM07 H1130154X;
label value APRDLM42 H1130155X;
label value APRDLT42 H1130156X;
label value APRTRM42 H1130157X;
label value APRTRT42 H1130158X;
label value ARTHDX H1130159X;
label value ASACUT53 H1130160X;
label value ASATAK31 H1130161X;
label value ASATAK53 H1130162X;
label value ASDALY53 H1130163X;
label value ASEVFL53 H1130164X;
label value ASIANP42 H1130165X;
label value ASMRCN53 H1130166X;
label value ASPKFL53 H1130167X;
label value ASPREV53 H1130168X;
label value ASPRIN53 H1130169X;
label value ASSTIL31 H1130170X;
label value ASSTIL53 H1130171X;
label value ASTHDX H1130172X;
label value ASWNFL53 H1130173X;
label value BEGRFM31 H1130174X;
label value BEGRFM42 H1130175X;
label value BEGRFM53 H1130176X;
label value BEGRFY31 H1130177X;
label value BEGRFY42 H1130178X;
label value BEGRFY53 H1130179X;
label value BENDIF31 H1130180X;
label value BENDIF53 H1130181X;
label value BLCKPR42 H1130182X;
label value BLIND42 H1130183X;
label value BMINDX53 H1130184X;
label value BOOST42 H1130185X;
label value BOWEL53 H1130186X;
label value BPCHEK53 H1130187X;
label value BPMLDX H1130188X;
label value BPMONT53 H1130189X;
label value BRSTEX53 H1130190X;
label value BSNTY31 H1130191X;
label value BSNTY42 H1130192X;
label value BSNTY53 H1130193X;
label value BUSIMP07 H1130194X;
label value BUSNP07X H1130195X;
label value CARECO42 H1130196X;
label value CASHP07X H1130197X;
label value CHAPPT42 H1130198X;
label value CHBMIX42 H1130199X;
label value CHCOUN42 H1130200X;
label value CHDDX H1130201X;
label value CHECK53 H1130202X;
label value CHEMPB42 H1130203X;
label value CHEXPL42 H1130204X;
label value CHGJ3142 H1130205X;
label value CHGJ4253 H1130206X;
label value CHHECR42 H1130207X;
label value CHILCR42 H1130208X;
label value CHILWW42 H1130209X;
label value CHLAGE H1130210X;
label value CHLCHK53 H1130211X;
label value CHLDP07X H1130212X;
label value CHLICO42 H1130213X;
label value CHLIHB42 H1130214X;
label value CHLIMI42 H1130215X;
label value CHLIMP07 H1130216X;
label value CHLIST42 H1130217X;
label value CHNDCR42 H1130218X;
label value CHNECP42 H1130219X;
label value CHOIC31 H1130220X;
label value CHOIC42 H1130221X;
label value CHOIC53 H1130222X;
label value CHOLCK53 H1130223X;
label value CHOLDX H1130224X;
label value CHPMCN42 H1130225X;
label value CHPMED42 H1130226X;
label value CHPMHB42 H1130227X;
label value CHPRRE42 H1130228X;
label value CHPRTM42 H1130229X;
label value CHRESP42 H1130230X;
label value CHRTCR42 H1130231X;
label value CHRTWW42 H1130232X;
label value CHSERV42 H1130233X;
label value CHSPEC42 H1130234X;
label value CHSRCN42 H1130235X;
label value CHSRHB42 H1130236X;
label value CHTHCO42 H1130237X;
label value CHTHER42 H1130238X;
label value CHTHHB42 H1130239X;
label value CLINIC42 H1130240X;
label value CLMDEP07 H1130241X;
label value CLMHIP07 H1130242X;
label value COGLIM31 H1130243X;
label value COGLIM53 H1130244X;
label value COVRMM H1130245X;
label value COVRYY H1130246X;
label value CSHCN42 H1130247X;
label value CSHIMP07 H1130248X;
label value CSTSVM42 H1130249X;
label value CSTSVT42 H1130250X;
label value DADPRO42 H1130251X;
label value DDBDYS31 H1130252X;
label value DDBDYS42 H1130253X;
label value DDBDYS53 H1130254X;
label value DDNSCL31 H1130255X;
label value DDNSCL42 H1130256X;
label value DDNSCL53 H1130257X;
label value DDNWRK31 H1130258X;
label value DDNWRK42 H1130259X;
label value DDNWRK53 H1130260X;
label value DEAF42 H1130261X;
label value DECIDE42 H1130262X;
label value DEDUCT07 H1130263X;
label value DENTAL42 H1130264X;
label value DENTCK53 H1130265X;
label value DENTIN31 H1130266X;
label value DENTIN42 H1130267X;
label value DENTIN53 H1130268X;
label value DEPDNT07 H1130269X;
label value DFTOUS42 H1130270X;
label value DIABDX H1130271X;
label value DIABW07F H1130272X;
label value DIFFPL42 H1130273X;
label value DIFFWG31 H1130274X;
label value DIFFWG42 H1130275X;
label value DIFFWG53 H1130276X;
label value DISVW31X H1130277X;
label value DISVW42X H1130278X;
label value DISVW53X H1130279X;
label value DIVDP07X H1130280X;
label value DIVIMP07 H1130281X;
label value DKWHRU42 H1130282X;
label value DNDLAY42 H1130283X;
label value DNDLPR42 H1130284X;
label value DNDLRS42 H1130285X;
label value DNTINS07 H1130286X;
label value DNTINS31 H1130287X;
label value DNUNAB42 H1130288X;
label value DNUNPR42 H1130289X;
label value DNUNRS42 H1130290X;
label value DOBMM H1130291X;
label value DOBYY H1130292X;
label value DOCELS42 H1130293X;
label value DPINRU07 H1130294X;
label value DPOTSD07 H1130295X;
label value DSA1C53 H1130296X;
label value DSCKFT53 H1130297X;
label value DSDIA53 H1130298X;
label value DSDIET53 H1130299X;
label value DSEB0653 H1130300X;
label value DSEY0653 H1130301X;
label value DSEY0753 H1130302X;
label value DSEY0853 H1130303X;
label value DSEYNV53 H1130304X;
label value DSEYPR53 H1130305X;
label value DSINSU53 H1130306X;
label value DSKIDN53 H1130307X;
label value DSMED53 H1130308X;
label value DSPRX53 H1130309X;
label value DVGEN07 H1130310X;
label value DVGEXP07 H1130311X;
label value DVGMCD07 H1130312X;
label value DVGMCR07 H1130313X;
label value DVGOFD07 H1130314X;
label value DVGOPR07 H1130315X;
label value DVGOPU07 H1130316X;
label value DVGOSR07 H1130317X;
label value DVGOTH07 H1130318X;
label value DVGPRV07 H1130319X;
label value DVGPTR07 H1130320X;
label value DVGSLF07 H1130321X;
label value DVGSTL07 H1130322X;
label value DVGTCH07 H1130323X;
label value DVGTRI07 H1130324X;
label value DVGVA07 H1130325X;
label value DVGWCP07 H1130326X;
label value DVOEXP07 H1130327X;
label value DVOMCD07 H1130328X;
label value DVOMCR07 H1130329X;
label value DVOOFD07 H1130330X;
label value DVOOPR07 H1130331X;
label value DVOOPU07 H1130332X;
label value DVOOSR07 H1130333X;
label value DVOOTH07 H1130334X;
label value DVOPRV07 H1130335X;
label value DVOPTR07 H1130336X;
label value DVORTH07 H1130337X;
label value DVOSLF07 H1130338X;
label value DVOSTL07 H1130339X;
label value DVOTCH07 H1130340X;
label value DVOTRI07 H1130341X;
label value DVOVA07 H1130342X;
label value DVOWCP07 H1130343X;
label value DVTEXP07 H1130344X;
label value DVTMCD07 H1130345X;
label value DVTMCR07 H1130346X;
label value DVTOFD07 H1130347X;
label value DVTOPR07 H1130348X;
label value DVTOPU07 H1130349X;
label value DVTOSR07 H1130350X;
label value DVTOT07 H1130351X;
label value DVTOTH07 H1130352X;
label value DVTPRV07 H1130353X;
label value DVTPTR07 H1130354X;
label value DVTSLF07 H1130355X;
label value DVTSTL07 H1130356X;
label value DVTTCH07 H1130357X;
label value DVTTRI07 H1130358X;
label value DVTVA07 H1130359X;
label value DVTWCP07 H1130360X;
label value EATHLT42 H1130361X;
label value EDUCYR H1130362X;
label value EICRDT07 H1130363X;
label value ELGRND07 H1130364X;
label value ELGRND31 H1130365X;
label value ELGRND42 H1130366X;
label value ELGRND53 H1130367X;
label value EMPHDX H1130368X;
label value EMPST31 H1130369X;
label value EMPST42 H1130370X;
label value EMPST53 H1130371X;
label value ENDRFM07 H1130372X;
label value ENDRFM31 H1130373X;
label value ENDRFM42 H1130374X;
label value ENDRFM53 H1130375X;
label value ENDRFY07 H1130376X;
label value ENDRFY31 H1130377X;
label value ENDRFY42 H1130378X;
label value ENDRFY53 H1130379X;
label value ENGHME42 H1130380X;
label value ENGSPK42 H1130381X;
label value ERDEXP07 H1130382X;
label value ERDMCD07 H1130383X;
label value ERDMCR07 H1130384X;
label value ERDOFD07 H1130385X;
label value ERDOPR07 H1130386X;
label value ERDOPU07 H1130387X;
label value ERDOSR07 H1130388X;
label value ERDOTH07 H1130389X;
label value ERDPRV07 H1130390X;
label value ERDPTR07 H1130391X;
label value ERDSLF07 H1130392X;
label value ERDSTL07 H1130393X;
label value ERDTCH07 H1130394X;
label value ERDTRI07 H1130395X;
label value ERDVA07 H1130396X;
label value ERDWCP07 H1130397X;
label value ERFEXP07 H1130398X;
label value ERFMCD07 H1130399X;
label value ERFMCR07 H1130400X;
label value ERFOFD07 H1130401X;
label value ERFOPR07 H1130402X;
label value ERFOPU07 H1130403X;
label value ERFOSR07 H1130404X;
label value ERFOTH07 H1130405X;
label value ERFPRV07 H1130406X;
label value ERFPTR07 H1130407X;
label value ERFSLF07 H1130408X;
label value ERFSTL07 H1130409X;
label value ERFTCH07 H1130410X;
label value ERFTRI07 H1130411X;
label value ERFVA07 H1130412X;
label value ERFWCP07 H1130413X;
label value ERTEXP07 H1130414X;
label value ERTMCD07 H1130415X;
label value ERTMCR07 H1130416X;
label value ERTOFD07 H1130417X;
label value ERTOPR07 H1130418X;
label value ERTOPU07 H1130419X;
label value ERTOSR07 H1130420X;
label value ERTOT07 H1130421X;
label value ERTOTH07 H1130422X;
label value ERTPRV07 H1130423X;
label value ERTPTR07 H1130424X;
label value ERTSLF07 H1130425X;
label value ERTSTL07 H1130426X;
label value ERTTCH07 H1130427X;
label value ERTTRI07 H1130428X;
label value ERTVA07 H1130429X;
label value ERTWCP07 H1130430X;
label value EVRETIRE H1130431X;
label value EVRUNAT H1130432X;
label value EVRUNINS H1130433X;
label value EVRWRK H1130434X;
label value EXPLOP42 H1130435X;
label value EXRCIS53 H1130436X;
label value FACLPR42 H1130437X;
label value FAMINC07 H1130438X;
label value FAMRFPYR H1130439X;
label value FAMSZE31 H1130440X;
label value FAMSZE42 H1130441X;
label value FAMSZE53 H1130442X;
label value FAMWT07C H1130443X;
label value FAMWT07F H1130444X;
label value FCRP1231 H1130445X;
label value FILEDR07 H1130446X;
label value FILER07 H1130447X;
label value FLSHOT53 H1130448X;
label value FLSTAT07 H1130449X;
label value FLUSHT53 H1130450X;
label value FMRS1231 H1130451X;
label value FNGRDF31 H1130452X;
label value FNGRDF53 H1130453X;
label value FOODMN07 H1130454X;
label value FOODST07 H1130455X;
label value FOODVL07 H1130456X;
label value FTSTU07X H1130457X;
label value FTSTU31X H1130458X;
label value FTSTU42X H1130459X;
label value FTSTU53X H1130460X;
label value GDCPBM42 H1130461X;
label value GDCPBT42 H1130462X;
label value GENDRP42 H1130463X;
label value GOTOUS42 H1130464X;
label value HAVEUS42 H1130465X;
label value HAVFUN42 H1130466X;
label value HEALTH42 H1130467X;
label value HEARAD42 H1130468X;
label value HEARDI42 H1130469X;
label value HEARMO42 H1130470X;
label value HEARNG42 H1130471X;
label value HEARSM42 H1130472X;
label value HELD31X H1130473X;
label value HELD42X H1130474X;
label value HELD53X H1130475X;
label value HELMET42 H1130476X;
label value HHAEXP07 H1130477X;
label value HHAGD07 H1130478X;
label value HHAMCD07 H1130479X;
label value HHAMCR07 H1130480X;
label value HHAOFD07 H1130481X;
label value HHAOPR07 H1130482X;
label value HHAOPU07 H1130483X;
label value HHAOSR07 H1130484X;
label value HHAOTH07 H1130485X;
label value HHAPRV07 H1130486X;
label value HHAPTR07 H1130487X;
label value HHASLF07 H1130488X;
label value HHASTL07 H1130489X;
label value HHATCH07 H1130490X;
label value HHATRI07 H1130491X;
label value HHAVA07 H1130492X;
label value HHAWCP07 H1130493X;
label value HHINDD07 H1130494X;
label value HHINFD07 H1130495X;
label value HHNEXP07 H1130496X;
label value HHNMCD07 H1130497X;
label value HHNMCR07 H1130498X;
label value HHNOFD07 H1130499X;
label value HHNOPR07 H1130500X;
label value HHNOPU07 H1130501X;
label value HHNOSR07 H1130502X;
label value HHNOTH07 H1130503X;
label value HHNPRV07 H1130504X;
label value HHNPTR07 H1130505X;
label value HHNSLF07 H1130506X;
label value HHNSTL07 H1130507X;
label value HHNTCH07 H1130508X;
label value HHNTRI07 H1130509X;
label value HHNVA07 H1130510X;
label value HHNWCP07 H1130511X;
label value HHTOTD07 H1130512X;
label value HIBPDX H1130513X;
label value HIDEG H1130514X;
label value HISPANX H1130515X;
label value HISPCAT H1130516X;
label value HLTHLF42 H1130517X;
label value HOMEBH42 H1130518X;
label value HONRDC31 H1130519X;
label value HONRDC42 H1130520X;
label value HONRDC53 H1130521X;
label value HOUR31 H1130522X;
label value HOUR42 H1130523X;
label value HOUR53 H1130524X;
label value HPDAP07 H1130525X;
label value HPDAU07 H1130526X;
label value HPDDE07 H1130527X;
label value HPDFE07 H1130528X;
label value HPDJA07 H1130529X;
label value HPDJL07 H1130530X;
label value HPDJU07 H1130531X;
label value HPDMA07 H1130532X;
label value HPDMY07 H1130533X;
label value HPDNO07 H1130534X;
label value HPDOC07 H1130535X;
label value HPDSE07 H1130536X;
label value HPEAP07 H1130537X;
label value HPEAU07 H1130538X;
label value HPEDE07 H1130539X;
label value HPEFE07 H1130540X;
label value HPEJA07 H1130541X;
label value HPEJL07 H1130542X;
label value HPEJU07 H1130543X;
label value HPEMA07 H1130544X;
label value HPEMY07 H1130545X;
label value HPENO07 H1130546X;
label value HPEOC07 H1130547X;
label value HPESE07 H1130548X;
label value HPNAP07 H1130549X;
label value HPNAU07 H1130550X;
label value HPNDE07 H1130551X;
label value HPNFE07 H1130552X;
label value HPNJA07 H1130553X;
label value HPNJL07 H1130554X;
label value HPNJU07 H1130555X;
label value HPNMA07 H1130556X;
label value HPNMY07 H1130557X;
label value HPNNO07 H1130558X;
label value HPNOC07 H1130559X;
label value HPNSE07 H1130560X;
label value HPOAP07 H1130561X;
label value HPOAU07 H1130562X;
label value HPODE07 H1130563X;
label value HPOFE07 H1130564X;
label value HPOJA07 H1130565X;
label value HPOJL07 H1130566X;
label value HPOJU07 H1130567X;
label value HPOMA07 H1130568X;
label value HPOMY07 H1130569X;
label value HPONO07 H1130570X;
label value HPOOC07 H1130571X;
label value HPOSE07 H1130572X;
label value HPRAP07 H1130573X;
label value HPRAU07 H1130574X;
label value HPRDE07 H1130575X;
label value HPRFE07 H1130576X;
label value HPRJA07 H1130577X;
label value HPRJL07 H1130578X;
label value HPRJU07 H1130579X;
label value HPRMA07 H1130580X;
label value HPRMY07 H1130581X;
label value HPRNO07 H1130582X;
label value HPROC07 H1130583X;
label value HPRSE07 H1130584X;
label value HPSAP07 H1130585X;
label value HPSAU07 H1130586X;
label value HPSDE07 H1130587X;
label value HPSFE07 H1130588X;
label value HPSJA07 H1130589X;
label value HPSJL07 H1130590X;
label value HPSJU07 H1130591X;
label value HPSMA07 H1130592X;
label value HPSMY07 H1130593X;
label value HPSNO07 H1130594X;
label value HPSOC07 H1130595X;
label value HPSSE07 H1130596X;
label value HRHOW31 H1130597X;
label value HRHOW42 H1130598X;
label value HRHOW53 H1130599X;
label value HRWG31X H1130600X;
label value HRWG42X H1130601X;
label value HRWG53X H1130602X;
label value HRWGIM31 H1130603X;
label value HRWGIM42 H1130604X;
label value HRWGIM53 H1130605X;
label value HSELIM31 H1130606X;
label value HSELIM53 H1130607X;
label value HSPLAP42 H1130608X;
label value HYSTER53 H1130609X;
label value IADL3M31 H1130610X;
label value IADL3M42 H1130611X;
label value IADL3M53 H1130612X;
label value IADLHP31 H1130613X;
label value IADLHP42 H1130614X;
label value IADLHP53 H1130615X;
label value INDCAT31 H1130616X;
label value INDCAT42 H1130617X;
label value INDCAT53 H1130618X;
label value INS07X H1130619X;
label value INS31X H1130620X;
label value INS42X H1130621X;
label value INS53X H1130622X;
label value INSAP07X H1130623X;
label value INSAT07X H1130624X;
label value INSAT31X H1130625X;
label value INSAT42X H1130626X;
label value INSAT53X H1130627X;
label value INSAU07X H1130628X;
label value INSC1231 H1130629X;
label value INSCOP07 H1130630X;
label value INSCOP31 H1130631X;
label value INSCOP42 H1130632X;
label value INSCOP53 H1130633X;
label value INSCOPE H1130634X;
label value INSCOV07 H1130635X;
label value INSDE07X H1130636X;
label value INSENDMM H1130637X;
label value INSENDYY H1130638X;
label value INSFE07X H1130639X;
label value INSJA07X H1130640X;
label value INSJL07X H1130641X;
label value INSJU07X H1130642X;
label value INSMA07X H1130643X;
label value INSMY07X H1130644X;
label value INSNO07X H1130645X;
label value INSOC07X H1130646X;
label value INSRPL42 H1130647X;
label value INSSE07X H1130648X;
label value INTIMP07 H1130649X;
label value INTRP07X H1130650X;
label value INTVLANG H1130651X;
label value IPDEXP07 H1130652X;
label value IPDIS07 H1130653X;
label value IPDMCD07 H1130654X;
label value IPDMCR07 H1130655X;
label value IPDOFD07 H1130656X;
label value IPDOPR07 H1130657X;
label value IPDOPU07 H1130658X;
label value IPDOSR07 H1130659X;
label value IPDOTH07 H1130660X;
label value IPDPRV07 H1130661X;
label value IPDPTR07 H1130662X;
label value IPDSLF07 H1130663X;
label value IPDSTL07 H1130664X;
label value IPDTCH07 H1130665X;
label value IPDTRI07 H1130666X;
label value IPDVA07 H1130667X;
label value IPDWCP07 H1130668X;
label value IPFEXP07 H1130669X;
label value IPFMCD07 H1130670X;
label value IPFMCR07 H1130671X;
label value IPFOFD07 H1130672X;
label value IPFOPR07 H1130673X;
label value IPFOPU07 H1130674X;
label value IPFOSR07 H1130675X;
label value IPFOTH07 H1130676X;
label value IPFPRV07 H1130677X;
label value IPFPTR07 H1130678X;
label value IPFSLF07 H1130679X;
label value IPFSTL07 H1130680X;
label value IPFTCH07 H1130681X;
label value IPFTRI07 H1130682X;
label value IPFVA07 H1130683X;
label value IPFWCP07 H1130684X;
label value IPNGTD07 H1130685X;
label value IPTEXP07 H1130686X;
label value IPTMCD07 H1130687X;
label value IPTMCR07 H1130688X;
label value IPTOFD07 H1130689X;
label value IPTOPR07 H1130690X;
label value IPTOPU07 H1130691X;
label value IPTOSR07 H1130692X;
label value IPTOTH07 H1130693X;
label value IPTPRV07 H1130694X;
label value IPTPTR07 H1130695X;
label value IPTSLF07 H1130696X;
label value IPTSTL07 H1130697X;
label value IPTTCH07 H1130698X;
label value IPTTRI07 H1130699X;
label value IPTVA07 H1130700X;
label value IPTWCP07 H1130701X;
label value IPZERO07 H1130702X;
label value IRAIMP07 H1130703X;
label value IRASP07X H1130704X;
label value JNTPID07 H1130705X;
label value JOBORG31 H1130706X;
label value JOBORG42 H1130707X;
label value JOBORG53 H1130708X;
label value JOBRSN42 H1130709X;
label value JTINRU07 H1130710X;
label value JTPAIN31 H1130711X;
label value JTPAIN53 H1130712X;
label value K6SUM42 H1130713X;
label value KEYNESS H1130714X;
label value KIDPRO42 H1130715X;
label value KNOWDR42 H1130716X;
label value LANGHM42 H1130717X;
label value LANGPR42 H1130718X;
label value LAPBLT42 H1130719X;
label value LFTDIF31 H1130720X;
label value LFTDIF53 H1130721X;
label value LKINFM42 H1130722X;
label value LKINFT42 H1130723X;
label value LOCATN42 H1130724X;
label value LSHLTH42 H1130725X;
label value LSTETH53 H1130726X;
label value MAMOGR53 H1130727X;
label value MARRY07X H1130728X;
label value MARRY31X H1130729X;
label value MARRY42X H1130730X;
label value MARRY53X H1130731X;
label value MCAID07 H1130732X;
label value MCAID07X H1130733X;
label value MCAID31 H1130734X;
label value MCAID31X H1130735X;
label value MCAID42 H1130736X;
label value MCAID42X H1130737X;
label value MCAID53 H1130738X;
label value MCAID53X H1130739X;
label value MCARE07 H1130740X;
label value MCARE07X H1130741X;
label value MCARE31 H1130742X;
label value MCARE31X H1130743X;
label value MCARE42 H1130744X;
label value MCARE42X H1130745X;
label value MCARE53 H1130746X;
label value MCARE53X H1130747X;
label value MCDAP07 H1130748X;
label value MCDAP07X H1130749X;
label value MCDAT07X H1130750X;
label value MCDAT31X H1130751X;
label value MCDAT42X H1130752X;
label value MCDAT53X H1130753X;
label value MCDAU07 H1130754X;
label value MCDAU07X H1130755X;
label value MCDDE07 H1130756X;
label value MCDDE07X H1130757X;
label value MCDEV07 H1130758X;
label value MCDFE07 H1130759X;
label value MCDFE07X H1130760X;
label value MCDHMO07 H1130761X;
label value MCDHMO31 H1130762X;
label value MCDHMO42 H1130763X;
label value MCDJA07 H1130764X;
label value MCDJA07X H1130765X;
label value MCDJL07 H1130766X;
label value MCDJL07X H1130767X;
label value MCDJU07 H1130768X;
label value MCDJU07X H1130769X;
label value MCDMA07 H1130770X;
label value MCDMA07X H1130771X;
label value MCDMC07 H1130772X;
label value MCDMC31 H1130773X;
label value MCDMC42 H1130774X;
label value MCDMY07 H1130775X;
label value MCDMY07X H1130776X;
label value MCDNO07 H1130777X;
label value MCDNO07X H1130778X;
label value MCDOC07 H1130779X;
label value MCDOC07X H1130780X;
label value MCDSE07 H1130781X;
label value MCDSE07X H1130782X;
label value MCRAP07 H1130783X;
label value MCRAP07X H1130784X;
label value MCRAU07 H1130785X;
label value MCRAU07X H1130786X;
label value MCRDE07 H1130787X;
label value MCRDE07X H1130788X;
label value MCREV07 H1130789X;
label value MCRFE07 H1130790X;
label value MCRFE07X H1130791X;
label value MCRJA07 H1130792X;
label value MCRJA07X H1130793X;
label value MCRJL07 H1130794X;
label value MCRJL07X H1130795X;
label value MCRJU07 H1130796X;
label value MCRJU07X H1130797X;
label value MCRMA07 H1130798X;
label value MCRMA07X H1130799X;
label value MCRMY07 H1130800X;
label value MCRMY07X H1130801X;
label value MCRNO07 H1130802X;
label value MCRNO07X H1130803X;
label value MCROC07 H1130804X;
label value MCROC07X H1130805X;
label value MCRPD07 H1130806X;
label value MCRPD07X H1130807X;
label value MCRPD31 H1130808X;
label value MCRPD31X H1130809X;
label value MCRPD42 H1130810X;
label value MCRPD42X H1130811X;
label value MCRPHO07 H1130812X;
label value MCRPHO31 H1130813X;
label value MCRPHO42 H1130814X;
label value MCRSE07 H1130815X;
label value MCRSE07X H1130816X;
label value MDDLAY42 H1130817X;
label value MDDLPR42 H1130818X;
label value MDDLRS42 H1130819X;
label value MDUNAB42 H1130820X;
label value MDUNPR42 H1130821X;
label value MDUNRS42 H1130822X;
label value MESBPR42 H1130823X;
label value MESHGT42 H1130824X;
label value MESVIS42 H1130825X;
label value MESWGT42 H1130826X;
label value MIDX H1130827X;
label value MILDIF31 H1130828X;
label value MILDIF53 H1130829X;
label value MINORP42 H1130830X;
label value MNHLTH31 H1130831X;
label value MNHLTH42 H1130832X;
label value MNHLTH53 H1130833X;
label value MOMPRO42 H1130834X;
label value MORE31 H1130835X;
label value MORE42 H1130836X;
label value MORE53 H1130837X;
label value MORECOVR H1130838X;
label value MORJOB31 H1130839X;
label value MORJOB42 H1130840X;
label value MORJOB53 H1130841X;
label value MSA07 H1130842X;
label value MSA31 H1130843X;
label value MSA42 H1130844X;
label value MSA53 H1130845X;
label value MYSELF42 H1130846X;
label value NATAMP42 H1130847X;
label value NERVAF42 H1130848X;
label value NEVILL42 H1130849X;
label value NEWARE42 H1130850X;
label value NEWDOC42 H1130851X;
label value NHRWG31 H1130852X;
label value NHRWG42 H1130853X;
label value NHRWG53 H1130854X;
label value NOASPR53 H1130855X;
label value NOFAT53 H1130856X;
label value NOGODR42 H1130857X;
label value NOINSBEF H1130858X;
label value NOINSTM H1130859X;
label value NOINUNIT H1130860X;
label value NOLIKE42 H1130861X;
label value NOREAS42 H1130862X;
label value NOSMOK42 H1130863X;
label value NUMEMP31 H1130864X;
label value NUMEMP42 H1130865X;
label value NUMEMP53 H1130866X;
label value NURSE53 H1130867X;
label value NWK31 H1130868X;
label value NWK42 H1130869X;
label value NWK53 H1130870X;
label value OBAEXP07 H1130871X;
label value OBAMCD07 H1130872X;
label value OBAMCR07 H1130873X;
label value OBAOFD07 H1130874X;
label value OBAOPR07 H1130875X;
label value OBAOPU07 H1130876X;
label value OBAOSR07 H1130877X;
label value OBAOTH07 H1130878X;
label value OBAPRV07 H1130879X;
label value OBAPTR07 H1130880X;
label value OBASLF07 H1130881X;
label value OBASST07 H1130882X;
label value OBASTL07 H1130883X;
label value OBATCH07 H1130884X;
label value OBATRI07 H1130885X;
label value OBAVA07 H1130886X;
label value OBAWCP07 H1130887X;
label value OBCEXP07 H1130888X;
label value OBCHIR07 H1130889X;
label value OBCMCD07 H1130890X;
label value OBCMCR07 H1130891X;
label value OBCOFD07 H1130892X;
label value OBCOPR07 H1130893X;
label value OBCOPU07 H1130894X;
label value OBCOSR07 H1130895X;
label value OBCOTH07 H1130896X;
label value OBCPRV07 H1130897X;
label value OBCPTR07 H1130898X;
label value OBCSLF07 H1130899X;
label value OBCSTL07 H1130900X;
label value OBCTCH07 H1130901X;
label value OBCTRI07 H1130902X;
label value OBCVA07 H1130903X;
label value OBCWCP07 H1130904X;
label value OBDEXP07 H1130905X;
label value OBDMCD07 H1130906X;
label value OBDMCR07 H1130907X;
label value OBDOFD07 H1130908X;
label value OBDOPR07 H1130909X;
label value OBDOPU07 H1130910X;
label value OBDOSR07 H1130911X;
label value OBDOTH07 H1130912X;
label value OBDPRV07 H1130913X;
label value OBDPTR07 H1130914X;
label value OBDRV07 H1130915X;
label value OBDSLF07 H1130916X;
label value OBDSTL07 H1130917X;
label value OBDTCH07 H1130918X;
label value OBDTRI07 H1130919X;
label value OBDVA07 H1130920X;
label value OBDWCP07 H1130921X;
label value OBEEXP07 H1130922X;
label value OBEMCD07 H1130923X;
label value OBEMCR07 H1130924X;
label value OBEOFD07 H1130925X;
label value OBEOPR07 H1130926X;
label value OBEOPU07 H1130927X;
label value OBEOSR07 H1130928X;
label value OBEOTH07 H1130929X;
label value OBEPRV07 H1130930X;
label value OBEPTR07 H1130931X;
label value OBESLF07 H1130932X;
label value OBESTL07 H1130933X;
label value OBETCH07 H1130934X;
label value OBETRI07 H1130935X;
label value OBEVA07 H1130936X;
label value OBEWCP07 H1130937X;
label value OBNEXP07 H1130938X;
label value OBNMCD07 H1130939X;
label value OBNMCR07 H1130940X;
label value OBNOFD07 H1130941X;
label value OBNOPR07 H1130942X;
label value OBNOPU07 H1130943X;
label value OBNOSR07 H1130944X;
label value OBNOTH07 H1130945X;
label value OBNPRV07 H1130946X;
label value OBNPTR07 H1130947X;
label value OBNSLF07 H1130948X;
label value OBNSTL07 H1130949X;
label value OBNTCH07 H1130950X;
label value OBNTRI07 H1130951X;
label value OBNURS07 H1130952X;
label value OBNVA07 H1130953X;
label value OBNWCP07 H1130954X;
label value OBOEXP07 H1130955X;
label value OBOMCD07 H1130956X;
label value OBOMCR07 H1130957X;
label value OBOOFD07 H1130958X;
label value OBOOPR07 H1130959X;
label value OBOOPU07 H1130960X;
label value OBOOSR07 H1130961X;
label value OBOOTH07 H1130962X;
label value OBOPRV07 H1130963X;
label value OBOPTO07 H1130964X;
label value OBOPTR07 H1130965X;
label value OBOSLF07 H1130966X;
label value OBOSTL07 H1130967X;
label value OBOTCH07 H1130968X;
label value OBOTHV07 H1130969X;
label value OBOTRI07 H1130970X;
label value OBOVA07 H1130971X;
label value OBOWCP07 H1130972X;
label value OBTEXP07 H1130973X;
label value OBTHER07 H1130974X;
label value OBTMCD07 H1130975X;
label value OBTMCR07 H1130976X;
label value OBTOFD07 H1130977X;
label value OBTOPR07 H1130978X;
label value OBTOPU07 H1130979X;
label value OBTOSR07 H1130980X;
label value OBTOTH07 H1130981X;
label value OBTOTV07 H1130982X;
label value OBTPRV07 H1130983X;
label value OBTPTR07 H1130984X;
label value OBTSLF07 H1130985X;
label value OBTSTL07 H1130986X;
label value OBTTCH07 H1130987X;
label value OBTTRI07 H1130988X;
label value OBTVA07 H1130989X;
label value OBTWCP07 H1130990X;
label value OBVEXP07 H1130991X;
label value OBVMCD07 H1130992X;
label value OBVMCR07 H1130993X;
label value OBVOFD07 H1130994X;
label value OBVOPR07 H1130995X;
label value OBVOPU07 H1130996X;
label value OBVOSR07 H1130997X;
label value OBVOTH07 H1130998X;
label value OBVPRV07 H1130999X;
label value OBVPTR07 H1131000X;
label value OBVSLF07 H1131001X;
label value OBVSTL07 H1131002X;
label value OBVTCH07 H1131003X;
label value OBVTRI07 H1131004X;
label value OBVVA07 H1131005X;
label value OBVWCP07 H1131006X;
label value OCCCAT31 H1131007X;
label value OCCCAT42 H1131008X;
label value OCCCAT53 H1131009X;
label value OFFER31X H1131010X;
label value OFFER42X H1131011X;
label value OFFER53X H1131012X;
label value OFFHOU42 H1131013X;
label value OFREMP31 H1131014X;
label value OFREMP42 H1131015X;
label value OFREMP53 H1131016X;
label value OHRTDX H1131017X;
label value ONGONG42 H1131018X;
label value ONJOB42 H1131019X;
label value OPAAP07 H1131020X;
label value OPAAU07 H1131021X;
label value OPADE07 H1131022X;
label value OPAEV07 H1131023X;
label value OPAFE07 H1131024X;
label value OPAJA07 H1131025X;
label value OPAJL07 H1131026X;
label value OPAJU07 H1131027X;
label value OPAMA07 H1131028X;
label value OPAMY07 H1131029X;
label value OPANO07 H1131030X;
label value OPAOC07 H1131031X;
label value OPASE07 H1131032X;
label value OPBAP07 H1131033X;
label value OPBAU07 H1131034X;
label value OPBDE07 H1131035X;
label value OPBEV07 H1131036X;
label value OPBFE07 H1131037X;
label value OPBJA07 H1131038X;
label value OPBJL07 H1131039X;
label value OPBJU07 H1131040X;
label value OPBMA07 H1131041X;
label value OPBMY07 H1131042X;
label value OPBNO07 H1131043X;
label value OPBOC07 H1131044X;
label value OPBSE07 H1131045X;
label value OPDEXP07 H1131046X;
label value OPDMCD07 H1131047X;
label value OPDMCR07 H1131048X;
label value OPDOFD07 H1131049X;
label value OPDOPR07 H1131050X;
label value OPDOPU07 H1131051X;
label value OPDOSR07 H1131052X;
label value OPDOTH07 H1131053X;
label value OPDPRV07 H1131054X;
label value OPDPTR07 H1131055X;
label value OPDRV07 H1131056X;
label value OPDSLF07 H1131057X;
label value OPDSTL07 H1131058X;
label value OPDTCH07 H1131059X;
label value OPDTRI07 H1131060X;
label value OPDVA07 H1131061X;
label value OPDWCP07 H1131062X;
label value OPFEXP07 H1131063X;
label value OPFMCD07 H1131064X;
label value OPFMCR07 H1131065X;
label value OPFOFD07 H1131066X;
label value OPFOPR07 H1131067X;
label value OPFOPU07 H1131068X;
label value OPFOSR07 H1131069X;
label value OPFOTH07 H1131070X;
label value OPFPRV07 H1131071X;
label value OPFPTR07 H1131072X;
label value OPFSLF07 H1131073X;
label value OPFSTL07 H1131074X;
label value OPFTCH07 H1131075X;
label value OPFTRI07 H1131076X;
label value OPFVA07 H1131077X;
label value OPFWCP07 H1131078X;
label value OPOEXP07 H1131079X;
label value OPOMCD07 H1131080X;
label value OPOMCR07 H1131081X;
label value OPOOFD07 H1131082X;
label value OPOOPR07 H1131083X;
label value OPOOPU07 H1131084X;
label value OPOOSR07 H1131085X;
label value OPOOTH07 H1131086X;
label value OPOPRV07 H1131087X;
label value OPOPTR07 H1131088X;
label value OPOSLF07 H1131089X;
label value OPOSTL07 H1131090X;
label value OPOTCH07 H1131091X;
label value OPOTHV07 H1131092X;
label value OPOTRI07 H1131093X;
label value OPOVA07 H1131094X;
label value OPOWCP07 H1131095X;
label value OPPEXP07 H1131096X;
label value OPPMCD07 H1131097X;
label value OPPMCR07 H1131098X;
label value OPPOFD07 H1131099X;
label value OPPOPR07 H1131100X;
label value OPPOPU07 H1131101X;
label value OPPOSR07 H1131102X;
label value OPPOTH07 H1131103X;
label value OPPPRV07 H1131104X;
label value OPPPTR07 H1131105X;
label value OPPSLF07 H1131106X;
label value OPPSTL07 H1131107X;
label value OPPTCH07 H1131108X;
label value OPPTRI07 H1131109X;
label value OPPVA07 H1131110X;
label value OPPWCP07 H1131111X;
label value OPSEXP07 H1131112X;
label value OPSMCD07 H1131113X;
label value OPSMCR07 H1131114X;
label value OPSOFD07 H1131115X;
label value OPSOPR07 H1131116X;
label value OPSOPU07 H1131117X;
label value OPSOSR07 H1131118X;
label value OPSOTH07 H1131119X;
label value OPSPRV07 H1131120X;
label value OPSPTR07 H1131121X;
label value OPSSLF07 H1131122X;
label value OPSSTL07 H1131123X;
label value OPSTCH07 H1131124X;
label value OPSTRI07 H1131125X;
label value OPSVA07 H1131126X;
label value OPSWCP07 H1131127X;
label value OPTEXP07 H1131128X;
label value OPTMCD07 H1131129X;
label value OPTMCR07 H1131130X;
label value OPTOFD07 H1131131X;
label value OPTOPR07 H1131132X;
label value OPTOPU07 H1131133X;
label value OPTOSR07 H1131134X;
label value OPTOTH07 H1131135X;
label value OPTOTV07 H1131136X;
label value OPTPRV07 H1131137X;
label value OPTPTR07 H1131138X;
label value OPTSLF07 H1131139X;
label value OPTSTL07 H1131140X;
label value OPTTCH07 H1131141X;
label value OPTTRI07 H1131142X;
label value OPTVA07 H1131143X;
label value OPTWCP07 H1131144X;
label value OPVEXP07 H1131145X;
label value OPVMCD07 H1131146X;
label value OPVMCR07 H1131147X;
label value OPVOFD07 H1131148X;
label value OPVOPR07 H1131149X;
label value OPVOPU07 H1131150X;
label value OPVOSR07 H1131151X;
label value OPVOTH07 H1131152X;
label value OPVPRV07 H1131153X;
label value OPVPTR07 H1131154X;
label value OPVSLF07 H1131155X;
label value OPVSTL07 H1131156X;
label value OPVTCH07 H1131157X;
label value OPVTRI07 H1131158X;
label value OPVVA07 H1131159X;
label value OPVWCP07 H1131160X;
label value OTHDYS31 H1131161X;
label value OTHDYS42 H1131162X;
label value OTHDYS53 H1131163X;
label value OTHEXP07 H1131164X;
label value OTHIMP07 H1131165X;
label value OTHINS42 H1131166X;
label value OTHMCD07 H1131167X;
label value OTHMCR07 H1131168X;
label value OTHNDD31 H1131169X;
label value OTHNDD42 H1131170X;
label value OTHNDD53 H1131171X;
label value OTHOFD07 H1131172X;
label value OTHOPR07 H1131173X;
label value OTHOPU07 H1131174X;
label value OTHOSR07 H1131175X;
label value OTHOTH07 H1131176X;
label value OTHPRV07 H1131177X;
label value OTHPTR07 H1131178X;
label value OTHRCP42 H1131179X;
label value OTHREA42 H1131180X;
label value OTHRP07X H1131181X;
label value OTHSLF07 H1131182X;
label value OTHSTL07 H1131183X;
label value OTHTCH07 H1131184X;
label value OTHTRI07 H1131185X;
label value OTHVA07 H1131186X;
label value OTHWCP07 H1131187X;
label value OTPAAT07 H1131188X;
label value OTPAAT31 H1131189X;
label value OTPAAT42 H1131190X;
label value OTPAAT53 H1131191X;
label value OTPBAT07 H1131192X;
label value OTPBAT31 H1131193X;
label value OTPBAT42 H1131194X;
label value OTPBAT53 H1131195X;
label value OTPUBA07 H1131196X;
label value OTPUBA31 H1131197X;
label value OTPUBA42 H1131198X;
label value OTPUBA53 H1131199X;
label value OTPUBB07 H1131200X;
label value OTPUBB31 H1131201X;
label value OTPUBB42 H1131202X;
label value OTPUBB53 H1131203X;
label value PACISP42 H1131204X;
label value PANEL H1131205X;
label value PAPSMR53 H1131206X;
label value PAYDR31 H1131207X;
label value PAYDR42 H1131208X;
label value PAYDR53 H1131209X;
label value PAYVAC31 H1131210X;
label value PAYVAC42 H1131211X;
label value PAYVAC53 H1131212X;
label value PBINFM42 H1131213X;
label value PBINFT42 H1131214X;
label value PBPWKM42 H1131215X;
label value PBPWKT42 H1131216X;
label value PBSVCM42 H1131217X;
label value PBSVCT42 H1131218X;
label value PDKAP07 H1131219X;
label value PDKAU07 H1131220X;
label value PDKDE07 H1131221X;
label value PDKFE07 H1131222X;
label value PDKJA07 H1131223X;
label value PDKJL07 H1131224X;
label value PDKJU07 H1131225X;
label value PDKMA07 H1131226X;
label value PDKMY07 H1131227X;
label value PDKNO07 H1131228X;
label value PDKOC07 H1131229X;
label value PDKSE07 H1131230X;
label value PEGAP07 H1131231X;
label value PEGAU07 H1131232X;
label value PEGDE07 H1131233X;
label value PEGFE07 H1131234X;
label value PEGJA07 H1131235X;
label value PEGJL07 H1131236X;
label value PEGJU07 H1131237X;
label value PEGMA07 H1131238X;
label value PEGMY07 H1131239X;
label value PEGNO07 H1131240X;
label value PEGOC07 H1131241X;
label value PEGSE07 H1131242X;
label value PENIMP07 H1131243X;
label value PENSP07X H1131244X;
label value PERSLA42 H1131245X;
label value PERWT07F H1131246X;
label value PHMONP07 H1131247X;
label value PHMONP31 H1131248X;
label value PHMONP42 H1131249X;
label value PHNREG42 H1131250X;
label value PHONE53 H1131251X;
label value PHQ242 H1131252X;
label value PHYACT53 H1131253X;
label value PHYSCL42 H1131254X;
label value PLCTYP42 H1131255X;
label value PMDINS07 H1131256X;
label value PMDINS31 H1131257X;
label value PMDLAY42 H1131258X;
label value PMDLPR42 H1131259X;
label value PMDLRS42 H1131260X;
label value PMEDIN31 H1131261X;
label value PMEDIN42 H1131262X;
label value PMEDIN53 H1131263X;
label value PMEDOP31 H1131264X;
label value PMEDOP42 H1131265X;
label value PMEDOP53 H1131266X;
label value PMEDPY31 H1131267X;
label value PMEDPY42 H1131268X;
label value PMEDPY53 H1131269X;
label value PMEDUP31 H1131270X;
label value PMEDUP42 H1131271X;
label value PMEDUP53 H1131272X;
label value PMNCNP07 H1131273X;
label value PMNCNP31 H1131274X;
label value PMNCNP42 H1131275X;
label value PMUNAB42 H1131276X;
label value PMUNPR42 H1131277X;
label value PMUNRS42 H1131278X;
label value PNGAP07 H1131279X;
label value PNGAU07 H1131280X;
label value PNGDE07 H1131281X;
label value PNGFE07 H1131282X;
label value PNGJA07 H1131283X;
label value PNGJL07 H1131284X;
label value PNGJU07 H1131285X;
label value PNGMA07 H1131286X;
label value PNGMY07 H1131287X;
label value PNGNO07 H1131288X;
label value PNGOC07 H1131289X;
label value PNGSE07 H1131290X;
label value POGAP07 H1131291X;
label value POGAU07 H1131292X;
label value POGDE07 H1131293X;
label value POGFE07 H1131294X;
label value POGJA07 H1131295X;
label value POGJL07 H1131296X;
label value POGJU07 H1131297X;
label value POGMA07 H1131298X;
label value POGMY07 H1131299X;
label value POGNO07 H1131300X;
label value POGOC07 H1131301X;
label value POGSE07 H1131302X;
label value POUAP07 H1131303X;
label value POUAU07 H1131304X;
label value POUDE07 H1131305X;
label value POUFE07 H1131306X;
label value POUJA07 H1131307X;
label value POUJL07 H1131308X;
label value POUJU07 H1131309X;
label value POUMA07 H1131310X;
label value POUMY07 H1131311X;
label value POUNO07 H1131312X;
label value POUOC07 H1131313X;
label value POUSE07 H1131314X;
label value POVCAT07 H1131315X;
label value POVLEV07 H1131316X;
label value PPRWKM42 H1131317X;
label value PPRWKT42 H1131318X;
label value PRDRNP07 H1131319X;
label value PRDRNP31 H1131320X;
label value PRDRNP42 H1131321X;
label value PREVCOVR H1131322X;
label value PREVEN42 H1131323X;
label value PRIAP07 H1131324X;
label value PRIAU07 H1131325X;
label value PRIDE07 H1131326X;
label value PRIDK07 H1131327X;
label value PRIDK31 H1131328X;
label value PRIDK42 H1131329X;
label value PRIDK53 H1131330X;
label value PRIEU07 H1131331X;
label value PRIEU31 H1131332X;
label value PRIEU42 H1131333X;
label value PRIEU53 H1131334X;
label value PRIFE07 H1131335X;
label value PRIJA07 H1131336X;
label value PRIJL07 H1131337X;
label value PRIJU07 H1131338X;
label value PRIMA07 H1131339X;
label value PRIMY07 H1131340X;
label value PRING07 H1131341X;
label value PRING31 H1131342X;
label value PRING42 H1131343X;
label value PRING53 H1131344X;
label value PRINO07 H1131345X;
label value PRIOC07 H1131346X;
label value PRIOG07 H1131347X;
label value PRIOG31 H1131348X;
label value PRIOG42 H1131349X;
label value PRIOG53 H1131350X;
label value PRIS07 H1131351X;
label value PRIS31 H1131352X;
label value PRIS42 H1131353X;
label value PRIS53 H1131354X;
label value PRISE07 H1131355X;
label value PRIV07 H1131356X;
label value PRIV31 H1131357X;
label value PRIV42 H1131358X;
label value PRIV53 H1131359X;
label value PRIVAT07 H1131360X;
label value PRIVAT31 H1131361X;
label value PRIVAT42 H1131362X;
label value PRIVAT53 H1131363X;
label value PROUT07 H1131364X;
label value PROUT31 H1131365X;
label value PROUT42 H1131366X;
label value PROUT53 H1131367X;
label value PROVTY42 H1131368X;
label value PROXY07 H1131369X;
label value PROXY31 H1131370X;
label value PROXY42 H1131371X;
label value PROXY53 H1131372X;
label value PRSAP07 H1131373X;
label value PRSAU07 H1131374X;
label value PRSDE07 H1131375X;
label value PRSFE07 H1131376X;
label value PRSJA07 H1131377X;
label value PRSJL07 H1131378X;
label value PRSJU07 H1131379X;
label value PRSMA07 H1131380X;
label value PRSMY07 H1131381X;
label value PRSNO07 H1131382X;
label value PRSOC07 H1131383X;
label value PRSSE07 H1131384X;
label value PRVDRL07 H1131385X;
label value PRVDRL31 H1131386X;
label value PRVDRL42 H1131387X;
label value PRVEV07 H1131388X;
label value PRVHMO07 H1131389X;
label value PRVHMO31 H1131390X;
label value PRVHMO42 H1131391X;
label value PRVMNC07 H1131392X;
label value PRVMNC31 H1131393X;
label value PRVMNC42 H1131394X;
label value PSA53 H1131395X;
label value PSTATS31 H1131396X;
label value PSTATS42 H1131397X;
label value PSTATS53 H1131398X;
label value PUB07X H1131399X;
label value PUB31X H1131400X;
label value PUB42X H1131401X;
label value PUB53X H1131402X;
label value PUBAP07X H1131403X;
label value PUBAT07X H1131404X;
label value PUBAT31X H1131405X;
label value PUBAT42X H1131406X;
label value PUBAT53X H1131407X;
label value PUBAU07X H1131408X;
label value PUBDE07X H1131409X;
label value PUBFE07X H1131410X;
label value PUBIMP07 H1131411X;
label value PUBJA07X H1131412X;
label value PUBJL07X H1131413X;
label value PUBJU07X H1131414X;
label value PUBMA07X H1131415X;
label value PUBMY07X H1131416X;
label value PUBNO07X H1131417X;
label value PUBOC07X H1131418X;
label value PUBP07X H1131419X;
label value PUBSE07X H1131420X;
label value RACEAX H1131421X;
label value RACEBX H1131422X;
label value RACETHNX H1131423X;
label value RACEWX H1131424X;
label value RACEX H1131425X;
label value RCHDIF31 H1131426X;
label value RCHDIF53 H1131427X;
label value READNW42 H1131428X;
label value RECPEP42 H1131429X;
label value REFDP07X H1131430X;
label value REFER53 H1131431X;
label value REFFRL42 H1131432X;
label value REFIMP07 H1131433X;
label value REGION07 H1131434X;
label value REGION31 H1131435X;
label value REGION42 H1131436X;
label value REGION53 H1131437X;
label value RESP07 H1131438X;
label value RESP31 H1131439X;
label value RESP42 H1131440X;
label value RESP53 H1131441X;
label value RESPCT42 H1131442X;
label value RETPLN31 H1131443X;
label value RETPLN42 H1131444X;
label value RETPLN53 H1131445X;
label value RFREL07X H1131446X;
label value RFREL31X H1131447X;
label value RFREL42X H1131448X;
label value RFREL53X H1131449X;
label value RNDFLG31 H1131450X;
label value RTHLTH31 H1131451X;
label value RTHLTH42 H1131452X;
label value RTHLTH53 H1131453X;
label value RTPLNM42 H1131454X;
label value RTPLNT42 H1131455X;
label value RUCLAS07 H1131456X;
label value RUCLAS31 H1131457X;
label value RUCLAS42 H1131458X;
label value RUCLAS53 H1131459X;
label value RUSIZE07 H1131460X;
label value RUSIZE31 H1131461X;
label value RUSIZE42 H1131462X;
label value RUSIZE53 H1131463X;
label value RXEXP07 H1131464X;
label value RXMCD07 H1131465X;
label value RXMCR07 H1131466X;
label value RXOFD07 H1131467X;
label value RXOPR07 H1131468X;
label value RXOPU07 H1131469X;
label value RXOSR07 H1131470X;
label value RXOTH07 H1131471X;
label value RXPRV07 H1131472X;
label value RXPTR07 H1131473X;
label value RXSLF07 H1131474X;
label value RXSTL07 H1131475X;
label value RXTOT07 H1131476X;
label value RXTRI07 H1131477X;
label value RXVA07 H1131478X;
label value RXWCP07 H1131479X;
label value SAFEST42 H1131480X;
label value SALEP07X H1131481X;
label value SALIMP07 H1131482X;
label value SAQELIG H1131483X;
label value SAQWT07F H1131484X;
label value SCHLBH42 H1131485X;
label value SCHLIM31 H1131486X;
label value SCHLIM53 H1131487X;
label value SCHPRO42 H1131488X;
label value SCLNBD31 H1131489X;
label value SCLNBD42 H1131490X;
label value SCLNBD53 H1131491X;
label value SEATBE53 H1131492X;
label value SEEDIF42 H1131493X;
label value SELDSI42 H1131494X;
label value SELFCM31 H1131495X;
label value SELFCM42 H1131496X;
label value SELFCM53 H1131497X;
label value SEX H1131498X;
label value SFFLAG42 H1131499X;
label value SIBPRO42 H1131500X;
label value SICEAS42 H1131501X;
label value SICPAY31 H1131502X;
label value SICPAY42 H1131503X;
label value SICPAY53 H1131504X;
label value SOCLIM31 H1131505X;
label value SOCLIM53 H1131506X;
label value SPOUID07 H1131507X;
label value SPOUID31 H1131508X;
label value SPOUID42 H1131509X;
label value SPOUID53 H1131510X;
label value SPOUIN07 H1131511X;
label value SPOUIN31 H1131512X;
label value SPOUIN42 H1131513X;
label value SPOUIN53 H1131514X;
label value SPRPRO42 H1131515X;
label value SSCIMP07 H1131516X;
label value SSECP07X H1131517X;
label value SSIDIS07 H1131518X;
label value SSIIMP07 H1131519X;
label value SSIP07X H1131520X;
label value SSNLJB31 H1131521X;
label value SSNLJB42 H1131522X;
label value SSNLJB53 H1131523X;
label value STAAP07 H1131524X;
label value STAAU07 H1131525X;
label value STADE07 H1131526X;
label value STAFE07 H1131527X;
label value STAJA07 H1131528X;
label value STAJL07 H1131529X;
label value STAJU07 H1131530X;
label value STAMA07 H1131531X;
label value STAMY07 H1131532X;
label value STANO07 H1131533X;
label value STAOC07 H1131534X;
label value STAPR07 H1131535X;
label value STAPR31 H1131536X;
label value STAPR42 H1131537X;
label value STAPR53 H1131538X;
label value STASE07 H1131539X;
label value STJBDD31 H1131540X;
label value STJBDD42 H1131541X;
label value STJBDD53 H1131542X;
label value STJBMM31 H1131543X;
label value STJBMM42 H1131544X;
label value STJBMM53 H1131545X;
label value STJBYY31 H1131546X;
label value STJBYY42 H1131547X;
label value STJBYY53 H1131548X;
label value STNDIF31 H1131549X;
label value STNDIF53 H1131550X;
label value STOMCH53 H1131551X;
label value STOOL53 H1131552X;
label value STPDIF31 H1131553X;
label value STPDIF53 H1131554X;
label value STPRAT07 H1131555X;
label value STPRAT31 H1131556X;
label value STPRAT42 H1131557X;
label value STPRAT53 H1131558X;
label value STRKDX H1131559X;
label value TAXFRM07 H1131560X;
label value TEMPJB31 H1131561X;
label value TEMPJB42 H1131562X;
label value TEMPJB53 H1131563X;
label value TIMALN42 H1131564X;
label value TMTKUS42 H1131565X;
label value TOTDED07 H1131566X;
label value TOTEXP07 H1131567X;
label value TOTMCD07 H1131568X;
label value TOTMCR07 H1131569X;
label value TOTOFD07 H1131570X;
label value TOTOPR07 H1131571X;
label value TOTOPU07 H1131572X;
label value TOTOSR07 H1131573X;
label value TOTOTH07 H1131574X;
label value TOTPRV07 H1131575X;
label value TOTPTR07 H1131576X;
label value TOTSLF07 H1131577X;
label value TOTSTL07 H1131578X;
label value TOTTCH07 H1131579X;
label value TOTTRI07 H1131580X;
label value TOTVA07 H1131581X;
label value TOTWCP07 H1131582X;
label value TRANS42 H1131583X;
label value TRBLE42 H1131584X;
label value TREATM42 H1131585X;
label value TRIAP07X H1131586X;
label value TRIAT07X H1131587X;
label value TRIAT31X H1131588X;
label value TRIAT42X H1131589X;
label value TRIAT53X H1131590X;
label value TRIAU07X H1131591X;
label value TRICH07X H1131592X;
label value TRICH31X H1131593X;
label value TRICH42X H1131594X;
label value TRICR07X H1131595X;
label value TRICR31X H1131596X;
label value TRICR42X H1131597X;
label value TRICR53X H1131598X;
label value TRIDE07X H1131599X;
label value TRIEV07 H1131600X;
label value TRIEX07X H1131601X;
label value TRIEX31X H1131602X;
label value TRIEX42X H1131603X;
label value TRIFE07X H1131604X;
label value TRIJA07X H1131605X;
label value TRIJL07X H1131606X;
label value TRIJU07X H1131607X;
label value TRILI07X H1131608X;
label value TRILI31X H1131609X;
label value TRILI42X H1131610X;
label value TRIMA07X H1131611X;
label value TRIMY07X H1131612X;
label value TRINO07X H1131613X;
label value TRIOC07X H1131614X;
label value TRIPR07X H1131615X;
label value TRIPR31X H1131616X;
label value TRIPR42X H1131617X;
label value TRISE07X H1131618X;
label value TRIST07X H1131619X;
label value TRIST31X H1131620X;
label value TRIST42X H1131621X;
label value TRSTP07X H1131622X;
label value TRTIMP07 H1131623X;
label value TTLP07X H1131624X;
label value TYPEPE42 H1131625X;
label value UNABLE31 H1131626X;
label value UNABLE53 H1131627X;
label value UNEIMP07 H1131628X;
label value UNEMP07X H1131629X;
label value UNHAP42 H1131630X;
label value UNINS07 H1131631X;
label value UNION31 H1131632X;
label value UNION42 H1131633X;
label value UNION53 H1131634X;
label value USBORN42 H1131635X;
label value USCNOT42 H1131636X;
label value USLIVE42 H1131637X;
label value VETIMP07 H1131638X;
label value VETSP07X H1131639X;
label value VISEXP07 H1131640X;
label value VISION42 H1131641X;
label value VISIT53 H1131642X;
label value VISMCD07 H1131643X;
label value VISMCR07 H1131644X;
label value VISOFD07 H1131645X;
label value VISOPR07 H1131646X;
label value VISOPU07 H1131647X;
label value VISOSR07 H1131648X;
label value VISOTH07 H1131649X;
label value VISPRV07 H1131650X;
label value VISPTR07 H1131651X;
label value VISSLF07 H1131652X;
label value VISSTL07 H1131653X;
label value VISTCH07 H1131654X;
label value VISTRI07 H1131655X;
label value VISVA07 H1131656X;
label value VISWCP07 H1131657X;
label value WAGEP07X H1131658X;
label value WAGIMP07 H1131659X;
label value WASAFDC H1131660X;
label value WASCHAMP H1131661X;
label value WASESTB H1131662X;
label value WASMCAID H1131663X;
label value WASMCARE H1131664X;
label value WASOTGOV H1131665X;
label value WASOTHER H1131666X;
label value WASPRIV H1131667X;
label value WASSSI H1131668X;
label value WASSTAT1 H1131669X;
label value WASSTAT2 H1131670X;
label value WASSTAT3 H1131671X;
label value WASSTAT4 H1131672X;
label value WASVA H1131673X;
label value WCMPP07X H1131674X;
label value WCPIMP07 H1131675X;
label value WHENST53 H1131676X;
label value WHITPR42 H1131677X;
label value WHNBPR42 H1131678X;
label value WHNBST42 H1131679X;
label value WHNBWL53 H1131680X;
label value WHNDEN42 H1131681X;
label value WHNEAT42 H1131682X;
label value WHNHEL42 H1131683X;
label value WHNHGT42 H1131684X;
label value WHNLAP42 H1131685X;
label value WHNPHY42 H1131686X;
label value WHNSAF42 H1131687X;
label value WHNSMK42 H1131688X;
label value WHNWGT42 H1131689X;
label value WILFIL07 H1131690X;
label value WKINBD31 H1131691X;
label value WKINBD42 H1131692X;
label value WKINBD53 H1131693X;
label value WLK3MO31 H1131694X;
label value WLK3MO53 H1131695X;
label value WLKDIF31 H1131696X;
label value WLKDIF53 H1131697X;
label value WLKLIM31 H1131698X;
label value WLKLIM53 H1131699X;
label value WRGLAS42 H1131700X;
label value WRHLTH42 H1131701X;
label value WRKLIM31 H1131702X;
label value WRKLIM53 H1131703X;
label value YCHJ3142 H1131704X;
label value YCHJ4253 H1131705X;
label value YNOINS31 H1131706X;
label value YNOINS42 H1131707X;
label value YNOINS53 H1131708X;
label value YNOUSC42 H1131709X;
label value ZIDEXP07 H1131710X;
label value ZIDMCD07 H1131711X;
label value ZIDMCR07 H1131712X;
label value ZIDOFD07 H1131713X;
label value ZIDOPR07 H1131714X;
label value ZIDOPU07 H1131715X;
label value ZIDOSR07 H1131716X;
label value ZIDOTH07 H1131717X;
label value ZIDPRV07 H1131718X;
label value ZIDPTR07 H1131719X;
label value ZIDSLF07 H1131720X;
label value ZIDSTL07 H1131721X;
label value ZIDTCH07 H1131722X;
label value ZIDTRI07 H1131723X;
label value ZIDVA07 H1131724X;
label value ZIDWCP07 H1131725X;
label value ZIFEXP07 H1131726X;
label value ZIFMCD07 H1131727X;
label value ZIFMCR07 H1131728X;
label value ZIFOFD07 H1131729X;
label value ZIFOPR07 H1131730X;
label value ZIFOPU07 H1131731X;
label value ZIFOSR07 H1131732X;
label value ZIFOTH07 H1131733X;
label value ZIFPRV07 H1131734X;
label value ZIFPTR07 H1131735X;
label value ZIFSLF07 H1131736X;
label value ZIFSTL07 H1131737X;
label value ZIFTCH07 H1131738X;
label value ZIFTRI07 H1131739X;
label value ZIFVA07 H1131740X;
label value ZIFWCP07 H1131741X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;

#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H113.LOG and a data file named H113.DTA.  If these files (H113.DTA and H113.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

